/*******************************************************************************
################################################################################
#                             (C) STMicroelectronics 2014
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License version 2 and only version 2 as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
#------------------------------------------------------------------------------
#                             Imaging Division
################################################################################
********************************************************************************/

/**
 * @file vl6180x_high_level_api.h
 *
 * @brief High level interface for the device, providing methods for basic
 * ranging and ambient light sensor measurement.
 *
 */

#ifndef VL6180X_HL_API
#define VL6180X_HL_API

#include "definitions.h"
#include "als_driver.h"
#include "ranging_driver.h"


#ifdef __cplusplus
extern "C"
{
#endif


/**
 * @brief Function to report the Vendor ID as a string.
 */
sensor_error get_vendor(uint8_t *pVendorStr);

/**
 * @brief Function to report the Device Version as a string.
 * id : device identifier. 0, if only one device. \n
 * Returns -1 to report error.
 */
sensor_error get_version(int32_t id, uint8_t *pVersionStr);


/**
 * @brief Function to return the Maximum range reported by the
 * sensor.
 */
uint32_t get_max_range();

/**
 * @brief Function to return the Minimum range reported by the
 * sensor.
 */
uint32_t get_min_range();

/**
 * @brief Function to perform device initialisation. \n
 * Returns -1 to report error.
 */
sensor_error initialise(uint8_t device_base_address);

/**
 * @brief Function to configure the device for single shot
 * ranging. \n
 * Returns -1 to report error.
 */
sensor_error start_ranging(int32_t id);

/**
 * @brief Function to configure the device for single shot
 * extended ranging. \n
 * Returns -1 to report error.
 */
sensor_error start_extended_ranging(int32_t id);

/**
 * @brief Function to perform a single shot range measurement
 * and reports the results to the given argument. \n
 * Pre-Requisite : Requires startRanging() to be called
 * beforehand. \n
 * Returns -1 to report error.
 */
sensor_error get_range_measurement(int32_t id, sensor_RangeData *pRangeData);

/**
 * @brief Function to configure the device for single shot
 * ALS measurements. \n
 * Returns -1 to report error.
 */
sensor_error start_als(int32_t id);

/**
 * @brief Function to perform a single shot ALS measurement
 * and reports the results to the given argument. \n
 * Pre-Requisite : Requires startAls() to be called beforehand. \n
 * Returns -1 to report error.
 */
sensor_error get_als_measurement(int32_t id, sensor_AlsData *pAlsData);

/**
 * @brief TBC
 */
sensor_error get_minimum_delay();

#ifdef __cplusplus
}
#endif

#endif  /* VL6180X_HL_API */


