/*******************************************************************************
################################################################################
#                             (C) STMicroelectronics 2014
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License version 2 and only version 2 as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
#------------------------------------------------------------------------------
#                             Imaging Division
################################################################################
********************************************************************************/

/*!
 *\file utilities.h
 *\brief Utilities module to contain common and useful routines.
 */

#ifndef _UTILITIES
#define _UTILITIES

#include "platform.h"
#include "definitions.h"

/**
 * @brief This function converts a given array of bytes to a string in hex
 * format. To be used when it is desired to display loose bytes as
 * a short, int, long long etc.
 *
 * If a valid length parameter is supplied only this number of bytes
 * will be converted. A count of 0 will be ignored.
 */
int32_t array2HexCString(uint8_t *byteArray, char *str, uint32_t count);

/**
 * @brief  This function unpacks an integer to a given array of bytes.
 */
int32_t unPackBytes(int32_t data, uint8_t *byteArray, int32_t size);

/**
 * @brief  This function packs an attay of bytes to a given integer.
 */
uint32_t packBytes(uint8_t *byteArray, uint32_t size);

/**
 * @brief This function round a float value to an integer value.
 */
int32_t roundFloatToInt(float_t floatVal);

/**
 * @brief Method to encode a float to 9:7 format and return as an
 * unsigned int. This is performed by shifting the float 7
 * bits to the left and then converting to unsigned int.
 */
uint32_t encodeTo9_7_Format(float_t value);

/**
 * @brief Method to decode a 9:7 formatted data word into a
 * float. The data word is shifted 7 bits to the right and
 * converted to float.
 */
float_t decodeFrom9_7_Format(uint32_t value);

/**
 * @brief Method to encode a float to 4:4 format and return as an
 * unsigned int. This is performed by shifting the float 4
 * bits to the left and then converting to unsigned int.
 */
uint32_t encodeTo4_4_Format(float_t value);

/**
 * @brief Method to decode a 4:4 formatted data word into a
 * float. The data word is shifted 4 bits to the right and
 * converted to float.
 */
float_t decodeFrom4_4_Format(uint32_t value);

#endif


