/*******************************************************************************
################################################################################
#                             (C) STMicroelectronics 2014
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License version 2 and only version 2 as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
#------------------------------------------------------------------------------
#                             Imaging Division
################################################################################
********************************************************************************/

/**
 * @file utilities.cpp
 *
 * Copyright (C) 2014 ST MicroElectronics
 *
 * Utilities module definition.
 *
 */

#include "utilities.h"
#include "platform.h"
#ifndef __KERNEL__
#include <cstring>
#include <cstdlib>
#include <stdio.h>
#else
#include <linux/kernel.h>
#include <linux/string.h>
#endif
#ifndef __KERNEL__
int32_t roundFloatToInt(float_t floatVal)
{
    floatVal += 0.5f;
    return (int32_t)floatVal;
}
#endif
int32_t unPackBytes(int32_t data, uint8_t *byteArray, int32_t size)
{
    const int32_t cByteBitShift = 8;
    const int32_t cByteMask     = 0xFF;
    int32_t bitShift = cByteBitShift * (size - 1);
	int32_t byteIndex = 0;

    for (byteIndex = 0; byteIndex < size; byteIndex++)
    {
        int32_t mask     = cByteMask << bitShift;
        int32_t value    = (data & mask) >> bitShift;
        bitShift -= cByteBitShift;
        byteArray[byteIndex] = (uint8_t)(value);
    }
		return 0;
}

uint32_t packBytes(uint8_t *byteArray, uint32_t size)
{
    const int cBitsPerByte = 8;
    uint32_t cBytesPerInt  = 4;
    uint32_t data = 0;
	unsigned int index = 0;

    if(size > cBytesPerInt)
    {
        size = cBytesPerInt;
    }

    for(index = 0; index < size; index++)
    {
        if(index > 0)
        {
            data <<= cBitsPerByte;
        }
        data += byteArray[index];
    }
    return data;
}

int32_t array2HexCString(uint8_t *byteArray, char *str, uint32_t count)
{
  uint32_t i;

    sprintf(str, "0x");

//    int32_t length = count;
//    for(int32_t i = 0; i < count; i++)
    for(i = 0; i < count; i++)
    {
        str += 2;
        sprintf(str, "%02X", (uint32_t)byteArray[i]);
    }
	return 0;
}

#ifndef __KERNEL__
uint32_t encodeTo9_7_Format(float_t value)
{
    const float_t cShiftFactor = 128.0f;
    const uint32_t cMax = 65535;
    uint32_t encodedVal = (uint32_t)roundFloatToInt(value * cShiftFactor);
    if (encodedVal > cMax)
    {
        encodedVal = cMax;
    }
    return encodedVal;
}

float_t decodeFrom9_7_Format(uint32_t value)
{
    const float_t cShiftFactor = 128.0f;
    return (float_t)value / cShiftFactor;
}


uint32_t encodeTo4_4_Format(float_t value)
{
    const float_t cShiftFactor = 16.0f;
    const uint32_t cMax = 255;
    uint32_t encodedVal = (uint32_t)roundFloatToInt(value * cShiftFactor);
    if (encodedVal > cMax)
    {
        encodedVal = cMax;
    }
    return encodedVal;
}

float_t decodeFrom4_4_Format(uint32_t value)
{
    const float_t cShiftFactor = 16.0f;
    return (float_t)value / cShiftFactor;
}
#endif

