/*******************************************************************************
################################################################################
#                             (C) STMicroelectronics 2014
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License version 2 and only version 2 as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
#------------------------------------------------------------------------------
#                             Imaging Division
################################################################################
********************************************************************************/


#include "platform.h"
#include "utilities.h"
#ifndef __KERNEL__
#include <stdio.h>
#else
#include <linux/kernel.h>
#include <linux/string.h>
#endif
static bool_t _i2c_log_started = FALSE;

void i2c_log_start(void)
{
	_i2c_log_started= TRUE;
}

void i2c_log_end(void)
{
	_i2c_log_started= FALSE;
}

void i2c_log_outputReadByteMsg(uint8_t value, uint32_t regOffset)
{
    const int32_t cMaxStrSize = 255;
    char str[cMaxStrSize];
    if (_i2c_log_started)
    {
        sprintf(str, "Read reg : 0x%04X, Val : 0x%02X\n", regOffset, (uint32_t)value);

        debug2_print(str);
    }
}

void i2c_log_outputReadWordMsg(uint16_t value, uint32_t regOffset)
{
    const int32_t cMaxStrSize = 255;
    char str[cMaxStrSize];
    if (_i2c_log_started)
    {
        sprintf(str, "Read reg : 0x%04X, Val : 0x%04X\n", regOffset, (uint32_t)value);

        debug2_print(str);
    }
}

void i2c_log_outputReadIntMsg(uint32_t value, uint32_t regOffset)
{
    const int32_t cMaxStrSize = 255;
    char str[cMaxStrSize];
	
    if (_i2c_log_started)
    {
        sprintf(str, "Read reg : 0x%04X, Val : 0x%08X\n", regOffset, (uint32_t)value);

        debug2_print(str);
    }
}

void i2c_log_outputReadMsg(uint8_t *data, uint32_t regOffset, int32_t size)
{
    const int32_t cMaxStrSize = 255;
    char str[cMaxStrSize];
    char dataStr[cMaxStrSize];

    if (_i2c_log_started)
    {
        array2HexCString(data, dataStr, size);

        sprintf(str, "Read reg : 0x%04X, Val : %s\n", regOffset, dataStr);

        debug2_print(str);
    }
}

void i2c_log_outputWriteByteMsg(uint8_t data, uint32_t regOffset)
{
    const int32_t cMaxStrSize = 255;
    char str[cMaxStrSize];
    if (_i2c_log_started)
    {
        sprintf(str, "Write reg : 0x%04X, Val : 0x%02X\n", regOffset, (uint32_t)data);

        debug2_print(str);
    }
}

void i2c_log_outputWriteWordMsg(uint16_t data, uint32_t regOffset)
{
    const int32_t cMaxStrSize = 255;
    char str[cMaxStrSize];
    if (_i2c_log_started)
    {

        sprintf(str, "Write reg : 0x%04X, Val : 0x%04X\n", regOffset, (uint32_t)data);

        debug2_print(str);
    }
}

void i2c_log_outputWriteIntMsg(uint32_t data, uint32_t regOffset)
{
    const int32_t cMaxStrSize = 255;
    char str[cMaxStrSize];
    if (_i2c_log_started)
    {
        sprintf(str, "Write reg : 0x%04X, Val : 0x%08X\n", regOffset, data);

        debug2_print(str);
    }
}

void i2c_log_outputWriteMsg(uint8_t *data, uint32_t regOffset, int32_t size)
{
    const int32_t cMaxStrSize = 255;
    char str[cMaxStrSize];
    char dataStr[cMaxStrSize];
    if (_i2c_log_started)
    {
        array2HexCString(data, dataStr, size);

        sprintf(str, "Write reg : 0x%04X, Val : %s\n", regOffset, dataStr);

        debug2_print(str);
    }
}

