/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __BLE_LOC_SERVICE_H__
#define __BLE_LOC_SERVICE_H__

#include "BLEDevice.h"

// Force value by using already existing data
#define UUID_LOC_INDEX_CHAR UUID_BATTERY_LEVEL_CHAR
#define UUID_LOC_SERVICE    UUID_GLUCOSE_SERVICE

/* Loc Service */
class LocService {
public:
        LocService(BLEDevice &_ble, uint8_t loc_index = 0) :
        ble(_ble),
        locIndex(loc_index),
        locIndexCharacteristic(GattCharacteristic::UUID_LOC_INDEX_CHAR, &locIndex, sizeof(locIndex), sizeof(locIndex),
                                   GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ) {

        static bool serviceAdded = false; /* We should only ever need to add the loc index service once. */
        if (serviceAdded) {
            return;
        }

        GattCharacteristic *charTable[] = {&locIndexCharacteristic};
        GattService         locService(GattService::UUID_LOC_SERVICE, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));

        ble.addService(locService);
        serviceAdded = true;
    }
 
private:
    BLEDevice            &ble;
    uint8_t              locIndex;
    GattCharacteristic   locIndexCharacteristic;
};

#endif /* #ifndef __BLE_LOC_SERVICE_H__*/
