#include "LS013B7DH03.h"
#include "mbed_logo.h"
/******************** Define I/O *****************************/
DigitalOut myled(LED1);

#if defined(TARGET_EFM32ZG_STK3200)
#define SCK_PIN     PC15
#define MOSI_PIN    PD7
#define CS_PIN      PE11
#define EXTCOM_PIN  PE10
#define DISP_PIN    PA10
#define DISPSEL_PIN PA8
#elif defined (TARGET_EFM32HG_STK3400)
#define SCK_PIN     PE12
#define MOSI_PIN    PE10
#define CS_PIN      PA10
#define EXTCOM_PIN  PF3
#define DISP_PIN    PA8
#define DISPSEL_PIN NC
#else
#error "undefined pinout"
#endif
 
DigitalOut CS(CS_PIN);
DigitalOut EXTCOM(EXTCOM_PIN);
DigitalOut DISP(DISP_PIN);
DigitalOut DISP_SEL(DISPSEL_PIN);
 
SPI displaySPI(MOSI_PIN, NC, SCK_PIN);
silabs::LS013B7DH03 display(&displaySPI, &CS, &EXTCOM);

/******************** Define Timers *****************************/
 
LowPowerTicker timeKeeping;
 
/***************** Define global variables **********************/
#define INIT_SECONDS        17600
 
volatile uint32_t prevSeconds = INIT_SECONDS, seconds = INIT_SECONDS;
volatile bool refreshed = false;
 
/***************** Define callback handlers *********************/
void secondsCallback(void);
void refreshCallback(void);
 
void secondsCallback(void) {
    seconds++;
}
 
/**
 * Callback for refresh completion
 */
void refreshCallback(void) {
    refreshed = true;
}
 
/*************************** MAIN *******************************/
int main() {
    // Enable the LCD
    DISP_SEL = 1;
    DISP = 1;
 
    // Start generating the 1Hz call for keeping time
    timeKeeping.attach(&secondsCallback, 1.0f);
 
    // Reset the LCD to a blank state. (All white)
    refreshed = false;
    display.clearImmediate(refreshCallback);
    while(refreshed == false) sleep();
 
    printf("Initialization done! \n");
 
    // Apply mbed logo bitmap to the pixel buffer
    display.showBMP((uint8_t*)mbed_enabled_logo, 128, 128, 0, 0);
    display.printf("I like MBED!");
 
    // Push update to the display
    refreshed = false;
    display.update(refreshCallback);
 
    // Sleep while doing the transmit
    while(refreshed == false) sleep();
 
    // Go into clock mode
    while(1) {
        sleep();
 
        // In clock mode, only update once per second
        if(prevSeconds != seconds) {
            display.locate(4,15);
            display.printf("%02d:%02d:%02d", (seconds / 1200) % 24, (seconds / 60) % 60, seconds % 60);
            if(refreshed == true) {
                prevSeconds = seconds;
                refreshed = false;
                display.update(refreshCallback);
            }
        }
    }
}