#include "mbed.h"

#include "SixStep_Lib.h"
#include "AnalogInBuffered.h"

/* start Parameters */

#define OUT1 PA_8
#define OUT2 PA_9
#define OUT3 PA_10
#define OUT1EN PC_10
#define OUT2EN PC_11
#define OUT3EN PC_12

#define HALL1 PA_15
#define HALL2 PB_3
#define HALL3 PB_10

#define POTENTIOMETER PB_1
#define POTENTIOMETER_BUFFER_SIZE 20

#define X_NUCLEO_IHM07001_LED PB_2

#define PWM_MAX 0.9f

/* end Parameters */

/* start globals */

PwmOut phaseA(OUT1);    //Out1, Green
DigitalOut phaseAEN(OUT1EN);
PwmOut phaseB(OUT2);    //Out2, Blue
DigitalOut phaseBEN(OUT2EN);
PwmOut phaseC(OUT3);   //Out3, White
DigitalOut phaseCEN(OUT3EN);

InterruptIn hallA(HALL1);   //H1, Green
InterruptIn hallB(HALL2);    //H2, Blue
InterruptIn hallC(HALL3);   //H3, White

AnalogInBuffered pot(POTENTIOMETER, POTENTIOMETER_BUFFER_SIZE);

InterruptIn button(USER_BUTTON);

DigitalOut redLed(X_NUCLEO_IHM07001_LED);
DigitalOut led(LED1);

Ticker interrupt;

/* end globals */

float pwmMax = PWM_MAX;
float pwmDuty;
int stall = 0;
void activate()
{
    stall = 1;
}

void Crise()    //state1, A0 B- C+
{   
    phaseA.write(0);
    phaseB.write(0);
    phaseC.write(pwmDuty);

    SixStep::Enable_CH1_CH2_Disable_CH3(phaseBEN, phaseCEN, phaseAEN);
}

void Bfall()    //state2, A+ B- C0
{
    phaseA.write(pwmDuty);
    phaseB.write(0);
    phaseC.write(0);

    SixStep::Enable_CH1_CH2_Disable_CH3(phaseAEN, phaseBEN, phaseCEN);
}

void Arise()    //state3, A+ B0 C-
{   
    phaseA.write(pwmDuty);
    phaseB.write(0);
    phaseC.write(0);

    SixStep::Enable_CH1_CH2_Disable_CH3(phaseAEN, phaseCEN, phaseBEN);
}

void Cfall()    //state4, A0 B+ C-
{
    phaseA.write(0);
    phaseB.write(pwmDuty);
    phaseC.write(0);

    SixStep::Enable_CH1_CH2_Disable_CH3(phaseBEN, phaseCEN, phaseAEN);
}

void Brise()    //state5, A- B+ C0
{
    phaseA.write(0);
    phaseB.write(pwmDuty);
    phaseC.write(0);

    SixStep::Enable_CH1_CH2_Disable_CH3(phaseAEN, phaseBEN, phaseCEN);
}

void Afall()    //state5, A- B0 C+
{
    phaseA.write(0);
    phaseB.write(0);
    phaseC.write(pwmDuty);

    SixStep::Enable_CH1_CH2_Disable_CH3(phaseAEN, phaseCEN, phaseBEN);
}

void Init()
{
    phaseA.period_us(10);
    phaseB.period_us(10);
    phaseC.period_us(10);
    
    phaseA.write(0);
    phaseB.write(0);
    phaseC.write(0);
    
    phaseAEN = 0;
    phaseBEN = 0;
    phaseCEN = 0;
    
    pwmDuty = pot.read() * PWM_MAX;  
    
    // sensored mode
    // attach appropriate ISRs to hall sensor interrupt pins 
    hallA.fall(&Afall);
    hallA.rise(&Arise);
    hallB.fall(&Bfall);
    hallB.rise(&Brise);
    hallC.fall(&Cfall);
    hallC.rise(&Crise);
}

void StartUp()
{
    int h1 = hallA.read();
    int h2 = hallB.read();
    int h3 = hallC.read();
    //check where we start
    if(h1 == 0 && h2 == 1 && h3 == 1)   //state1
    {
        Crise();
        Bfall();
    }
    else if(h1 == 0 && h2 == 0 && h3 == 1)  //state2
    {
        Bfall();
        Arise();
    }
    else if(h1 == 1 && h2 == 0 && h3 == 1)  //state3
    {
        Arise();
        Cfall();
    }
    else if(h1 == 1 && h2 == 0 && h3 == 0)     //state4
    {
        Cfall();
        Brise();
    }
    else if(h1 == 1 && h2 == 1 && h3 == 0)  //state5
    {
        Brise();
        Afall();
    }
    else    //state6
    {
        Afall();
        Crise();
    }
}

int main() {     
    //wait until button push to start
    button.rise(&activate);
    while(stall == 0) {
        led = !led;
        wait(1);
    }
        
    Init();
    StartUp();
    
    while(1) {
        led = !led;
        pwmDuty = pot.buffered_read() * PWM_MAX;
        wait(0.05);
    }
}
