#include "AnalogInBuffered.h"

AnalogInBuffered::AnalogInBuffered(PinName pin, int buffer_size)
:
AnalogIn(pin),
mBufferSize(buffer_size),
mCount(0),
mSum(0.0),
mLastValue(0.0)
{}

float AnalogInBuffered::buffered_read()
{
    if (mCount == mBufferSize)
    {
        mLastValue = mSum / mBufferSize;
        mCount = 0;
        mSum = 0.0;
    }
    mSum += read();
    mCount = mCount + 1;
    
    return mLastValue;
}
