#ifndef ANALOGINBUFFERED_H
#define ANALOGINBUFFERED_H

#include "mbed.h"

/*
    This class extends the mbed AnalogIn class to include a buffered_read()
    
    buffered_read() will save values to a buffer each time it is called.
    Once the buffer reaches a buffer size, it will save the average.
    Then it returns the last saved values (default: 0.0)
*/

class AnalogInBuffered : public AnalogIn
{
    public:
    AnalogInBuffered(PinName pin, int buffer_size);
    
    float buffered_read();
    
    private:
    int mBufferSize;
    
    int mCount;
    float mSum;
    float mLastValue;
};

#endif