#include "mbed.h"

#include "EthernetInterface.h"
#include "RealTimeClock.h"
#include "SimpleNTP.h"

EthernetInterface ether;
RealTimeClock rtc;
DigitalOut led[]= {LED1, LED2, LED3, LED4};

void setTime()
{
   ether.init();
   ether.connect();
   led[1]= 1;
   wait(2);

   SimpleNTP sntp;
   SimpleNTP::Result resultNTP;
   resultNTP= sntp.setNTPServer("ntp.sanoh.com");
   led[2]= 1;
   if(resultNTP == SimpleNTP::SUCCESS) {
       led[0]= 0;
       wait(2);
       long timeEpoch= sntp.getNetworkTime();
       if(rtc.setRealTime(timeEpoch))
           led[1]= 0;
   }
   if(sntp.close() == SimpleNTP::SUCCESS)
       led[2]= 0;
   return;
}
int main()
{
   led[0]= 1;
   setTime();
   while(1) {
       led[3]= !led[3];
       wait(0.2);
   }
}
