#include "mbed.h"

Serial pc(USBTX, USBRX);

InterruptIn botao_SW1(D2);
InterruptIn botao_SW2(D7);

Timer debounceSW1Fall;
Timer debounceSW2Fall;
Timer debounceSW1Rise;
Timer debounceSW2Rise;
Timer avanco;

AnalogIn Shunt(A5);
float Corrente;

DigitalOut saida_IN1(D10);
DigitalOut saida_IN2(D8);
DigitalOut saida_EN(D9);

bool SW1 = 1;
bool SW2 = 1;
bool IN1 = 0;
bool IN2 = 0;

void DSW1Fall(){
    
    if (debounceSW1Fall.read_ms() > 200) {
        SW1 = 0;
        debounceSW1Fall.reset();
        pc.printf("DSW1Fall \n\r");
        
        avanco.start();
        }
    }
    
void DSW2Fall(){
    
    if (debounceSW2Fall.read_ms() > 200) {
        SW2 = 0;
        debounceSW2Fall.reset();
        pc.printf("DSW2Fall \n\r");
        }
    }
    
void DSW1Rise(){
    if (debounceSW1Rise.read_ms() > 200) {
        if(avanco.read_ms() >= 500) {
            avanco.stop();
            avanco.reset();
        }
        else if(avanco.read_ms() < 500){
            SW1 = 1;
        }
        debounceSW1Rise.reset();
        pc.printf("DSW1Rise \n\r");
        }
    }
    
void DSW2Rise(){
    if (debounceSW2Rise.read_ms() > 200) {
        SW2 = 1;
        debounceSW2Rise.reset();
        pc.printf("DSW2Rise \n\r");
        }
    }
    
int main() {
    debounceSW1Fall.start();
    debounceSW2Fall.start();
    debounceSW1Rise.start();
    debounceSW2Rise.start();
    
    botao_SW1.rise(&DSW1Rise);
    botao_SW1.fall(&DSW1Fall);
    botao_SW2.rise(&DSW2Rise);
    botao_SW2.fall(&DSW2Fall);
    
    while(1){
        
        Corrente = 3.3f*Shunt;
        
        if (Corrente > 0.7f){
            if (IN1 && !IN2){
                saida_IN1 = IN2;
                saida_IN2 = IN1;
                wait_ms(250);
            }
            else if (IN2 && !IN1){
                saida_IN1 = IN2;
                saida_IN2 = IN1;
                wait_ms(250);
            }
            saida_IN1 = 0;
            saida_IN2 = 0;
            SW1 = 1;
            SW2 = 1;
            wait_ms(1000);
        }
            
        if (SW1 == 0){
            IN1 = 1; IN2 = 0;
            saida_EN = 1;
            saida_IN1 = IN1;
            saida_IN2 = IN2;
            wait(0.01);
            }
        
        else if (SW2 == 0){
            IN1 = 0; IN2 = 1;
            saida_EN = 1;
            saida_IN1 = IN1;
            saida_IN2 = IN2;
            wait(0.01);
            }
        else {
            IN1 = 0; IN2 = 0;
            saida_EN = 0;
            saida_IN1 = IN1;
            saida_IN2 = IN2;
            wait(0.01);
            }
        wait(0.01);     
        pc.printf("Timer: %.2f s \n\r", avanco.read());
    }
}
