#include "mbed.h"
#include "PINNAMES_mbed.h"
#include "SPICOMMANDS.h"
#include "PROTOTYPES.h"
#include "TABLES.h"

const int spiBitrate=250000;
bool arduino_task_done = false;
uint8_t write_buf [8];

int main() {
        
    // initialise write_buf
    write_buf[0] = 0xAA; //message start
    write_buf[1] = MEGA1; //chip_ID
    write_buf[2] = do_nothing; //command
    write_buf[3] = 0x00;
    write_buf[4] = 0x00;
    write_buf[5] = 0x00; //temp device number
    write_buf[6] = 0x00;
    write_buf[7] = GetSum();
    
    char read_buf [8];
    for (int i = 0; i < 8; ++i) {
        read_buf[i] = 0;
    }
    
    while(1) {
        spi.format(8,3);
        spi.frequency(spiBitrate);
        
        // REQUEST TEMPERATURES
        write_buf[2] = request_temps;
        write_buf[7] = GetSum();
        
        chipSelect = 0;
        wait_us(70);
        for (int i = 0; i < 8; ++i) {
            spi.write(write_buf[i]);
        }
        
        
        while (!arduino_task_done) {
            wait_us(10);
            for (int i = 0; i < 8; ++i) {
            read_buf[i] = (uint8_t) spi.write(0xFA);
            }
            if (read_buf[6] == 0x01) {
                //task done
                arduino_task_done = true;    
            }
        } 
        chipSelect = 1;
        wait_us(10);
        
        
        //READ PROBE 1
        write_buf[2] = read_onetemp_only;
        write_buf[5] = 0x01;
        write_buf[7] = GetSum();
        chipSelect = 0;
        wait_us(70);
        for (int i = 0; i < 8; ++i) {
            spi.write(write_buf[i]);
        }
        
        while (!arduino_task_done) {
            wait_us(10);
            for (int i = 0; i < 8; ++i) {
            read_buf[i] = (uint8_t) spi.write(0xFA);
            }
            if (read_buf[6] == 0x01) {
                //task done
                arduino_task_done = true;    
            }
        } 
        chipSelect = 1;
        wait_us(10);
        
        printf("Response from Arduino is ");
        for (int i = 0; i < 8; ++i) {
            printf("%d ", read_buf[i]);
            //if (read_buf[i] == 32) printf("this is 32");
            read_buf[i] = 0x00;
        }
        printf("\r\n");
        
        
        //READ PROBE 2
        write_buf[2] = read_onetemp_only;
        write_buf[5] = 0x02;
        write_buf[7] = GetSum();
        chipSelect = 0;
        wait_us(70);
        for (int i = 0; i < 8; ++i) {
            spi.write(write_buf[i]);
        }
        
        while (!arduino_task_done) {
            wait_us(10);
            for (int i = 0; i < 8; ++i) {
            read_buf[i] = (uint8_t) spi.write(0xFA);
            }
            if (read_buf[6] == 0x01) {
                //task done
                arduino_task_done = true;    
            }
        } 
        
        chipSelect = 1;
        wait_us(10);
        
        printf("Response from Arduino is ");
        for (int i = 0; i < 8; ++i) {
            printf("%d ", read_buf[i]);
            //if (read_buf[i] == 32) printf("this is 32");
            read_buf[i] = 0x00;
        }
        printf("\r\n");
        
        
        wait(1);
    }

}
uint8_t GetSum() {
    uint8_t sum = write_buf[0] + write_buf[1] + write_buf[2] + write_buf[3] + write_buf[4] + write_buf[5];
    return sum;
}