#include "mbed.h"

#include "stm32l475e_iot01_accelero.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

InterruptIn button(USER_BUTTON);
int16_t pDataXYZ[3] = {0};

void toggle() {
    printf("ACCELERO_X = %d\n", pDataXYZ[0]);
    printf("ACCELERO_Y = %d\n", pDataXYZ[1]);
    printf("ACCELERO_Z = %d\n\n", pDataXYZ[2]);
}

bool is_board_horizontal() {
    return (pDataXYZ[2] < 1030 && pDataXYZ[2] > 950) || (pDataXYZ[2] < -950 && pDataXYZ[2] > -1030);
}

bool is_board_vertical_short() {
    return (pDataXYZ[0] < -950  && pDataXYZ[0] > -1030) || (pDataXYZ[0] < 1030 && pDataXYZ[0] > 950);
}

bool is_board_vertical_long() {
    return (pDataXYZ[1] < 1030 && pDataXYZ[1] > 950) || (pDataXYZ[1] < -950 && pDataXYZ[1] > -1030);
}

void blink_led(int led1_status, int led2_status, int led3_status, DigitalOut led){
    printf("%d - %d - %d\n", led1_status, led2_status, led3_status);
    led1 = led1_status;
    led2 = led2_status;
    led3 = led3_status;
    wait(1);
    led = !led;
}

void blink_all(){
    led1 = 1;
    led2 = 1;
    led3 = 1;
    wait(1);
    led1 = 0;
    led2 = 0;
    led3 = 0;
}

int main(){
    button.rise(&toggle);
    BSP_ACCELERO_Init();
    while(true){
        BSP_ACCELERO_AccGetXYZ(pDataXYZ);
        if((!is_board_vertical_long() && !is_board_vertical_short() && !is_board_horizontal())){
            blink_all();
        } else {
            if(is_board_horizontal() && !is_board_vertical_short() && !is_board_vertical_long()){
                blink_led(1,0,0, led1);
            } else if(!is_board_horizontal() && is_board_vertical_short() && !is_board_vertical_long()){
                blink_led(0,1,0, led2);
            } else if(!is_board_horizontal() && !is_board_vertical_short() && is_board_vertical_long()){
                blink_led(0,0,1, led3);
            }
        }
        wait(1);
    }
}