#include "mbed.h"

DigitalOut led1(LED1);
InterruptIn button(USER_BUTTON);
EventQueue queue(32 * EVENTS_EVENT_SIZE);
Thread t;
time_t pressed_seconds = time(NULL);

void blink_led(){
    // Blink the led two times if button pressed two times in two seconds
    led1 = !led1;
    wait(0.5);
    led1 = !led1;
    wait(0.5);
    led1 = !led1;
    wait(0.5);
    led1 = !led1;
}
void rise_handler_thread_context(void) {
    if(pressed_seconds - time(NULL) > 2){
        pressed_seconds = time(NULL);
    } else {
        blink_led();
        pressed_seconds = time(NULL);
    }
}

void rise_handler_iterrupt_context(void) {
    // Execute the time critical part first
    // The rest can execute later in user context (and can contain code that's not interrupt safe)
    // We use the 'queue.call' function to add an event (the call to 'rise_handler_user_context') to the queue
    queue.call(rise_handler_thread_context);
}

void fall_handler(void) {
    printf("I am a string\n");  
}

int main() {
    // Start the event queue
    t.start(callback(&queue, &EventQueue::dispatch_forever));
    printf("Starting in context %p\r\n", Thread::gettid());
    // The 'rise' handler will execute in IRQ context
    button.rise(rise_handler_iterrupt_context);
    // The 'fall' handler will execute in the context of thread 't'
    button.fall(queue.event(fall_handler));
}
