/**************************************************************************

   Header file for the Nucleo32 F303K8 Board 

MBED page for the board:
https://os.mbed.com/platforms/ST-Nucleo-F303K8/

Basic requirements for a board are:
  MBED Compatible
  2 DACs or more
  4 ADCs or more
That includes the following Nucleo Boards

 Board           DACs Flash  RAM    
 Nucleo64-F303RE  2*  512k   64k + 16k     
 Nucleo64-L152RE  2*  512k   80k     
 Nucleo32-F303K8  3   64k    12k + 4k   (This board)    
 Nucleo64-F072RB  2   128k   16k
 Nucleo64-F091RC  2   256k   32k
 Nucleo64-F334R8  3   64k    12k + 4k
 Nucleo64-F446RE  2   512k   128k
 Nucleo64-L073RZ  2   192k   20k
 Nucleo64-L476RG  2   1M     128k

(*) In DACs mean that one DAC has reduced range because
    it is connected to the board LCD

History:

  2017/02/24 : First version
               It seems that there are problems with the serial at MBED
               Waiting for the problem to be corrected
   
*************************************************************************/   
   
#define BSTRING  "Nucleo32-F303K8 Slab"   

#define F_SIZE  64
#define R_SIZE  16

// ADCs

#define AD1 A0
#define AD2 A1
#define AD3 A6
#define AD4 A7

// DACs

#define DA1    A3
#define DA2    A4
#define EXIST_DAC3
#define DA3    A5

// Board capabilities implemented in firmware
#define NDACS       3           // Number of DACs
#define NADCS       4           // Number of ADCs
#define BSIZE       3000        // Unified buffer size (in samples)
#define MAX_STIME   100.0f      // Maximum sample period is 100s
#define MAX_S_M     100         //   Mantissa
#define MAX_S_E     0           //   Exponent
#define MIN_STIME   0.000025f   // Minimum sample period is 20us
#define MIN_S_M     20          //   Mantissa
#define MIN_S_E     -6          //   Exponent
#define VDD_M       33          //   Vdd Mantissa
#define VDD_E       -1          //       Exponent
#define VREF_M      33          //   Vref Mantissa
#define VREF_E      -1          //        Exponent
#define DAC_BITS    12          // Number of DAC bits
#define ADC_BITS    12          // Number of ADC bits
#define MAX_SF      38000       // Maximum sample freq. for f response
#define MAX_SF_M    38          //   Mantissa
#define MAX_SF_E     3          //   Exponent

// List of DAC and ADC pins
#define PIN_LIST "A3|A4|A5|A0|A1|A6|A7|$"
