#include "mbed.h"
#include "EthernetInterface.h"
#include "MODSERIAL.h"
#include "IO.h"

extern "C" void mbed_reset();

char Version[50] = "# AF_IO V05    22.07.2018\r\n";
char NoPower[50] = "# Keine 24V Versorgung ! \r\n";
char LineStr[50] = "####################################\r\n";

MODSERIAL USB(USBTX, USBRX);  // HardwareBuffer tx, rx
I2C I2CIO(p28, p27);          // I2C DigIOs onBoard
InterruptIn INTI2C01(p21);    // I2C DigIn  Interupt
InterruptIn INT_TMC1(p11);    // I2C DigIn  Interupt
InterruptIn INT_TMC2(p12);    // I2C DigIn  Interupt
int IOBase_IOs  = 0x40;       // I2C Adresse 
SPI spi(p5, p6, p7);          // DA-Wandler  mosi, miso, sclk

IO mIO;                       // Init IO-Modul
//EthernetInterface eth;
//UDPSocket server;
//Endpoint  client;
//const int SERVER_PORT = 50020;

DigitalOut  led1(LED1);
DigitalOut  led2(LED2);
DigitalOut  led3(LED3);
DigitalOut  DAC_CS1(p13);     // DA-Wandler
DigitalOut  TriggerOut(p18);  // AD-Wandler Mesurement

DigitalOut  US1_Pos(p14);
DigitalOut  US1_Gnd(p22);
DigitalOut  US2_Pos(p23);
DigitalOut  US2_Gnd(p24);

Timeout     US_ResetTeach;
bool        US_TeachDone=false;
bool        US_TeachAktiv=false;

bool        DataAsyncSend=true;
bool        DataSyncRunning = false;

AnalogIn    ain1(p20);        // US-Sensor1
AnalogIn    ain2(p19);        // US-Sensor2
AnalogIn    ain3(p17);        // P17 - Faulhaber MotorError
AnalogIn    ain4(p16);        // 24V
AnalogIn    ain5(p15);        // 5V

double U_Analog1  = 0;        // US-Sensor1
double U_Analog2  = 0;        // US-Sensor2
double U_Analog3  = 0;        // P17
double U_Analog4  = 0;        // 24V
double U_Analog5  = 0;        // 5V

bool   DigIN_Change = false;
char   DigIN01      = 0;        // 8 Bit Input
char   DigOUT01     = 0;        // 8 Bit Output

int    MainLoopCnt  = 0;
int    MainLoopCnt2 = 0;
int    MainLoopCnt3 = 0;

//char   UDP_CharBuf[256];
bool   EthernetConnection = false;

Ticker AnalogDataTimer;
int    AD_uSek   = 4000;
int    DataPoints= 500;
double Data1[1000];
double Data2[1000];
int    Coordinate[1000];
int    DataCnt=0;
int    DataOutCnt=0;
double GainFactor=1.6f;

//#####################################################################################
// Init Hardware
//#####################################################################################
void Init_HW()
{
   US1_Pos=false;
   US1_Gnd=false;
   US2_Pos=false;
   US2_Gnd=false;

   USB.baud(57600);wait_ms(100);
   USB.printf("\r\n");wait_ms(100);
   USB.printf(LineStr);wait_ms(100);
   USB.printf(Version);wait_ms(100);
   USB.printf(LineStr);wait_ms(100);

   int ret = mIO.Init_I2C_IOs();
   USB.printf("# Init I2C: %d\r\n",ret); wait_ms(100);   
   DigOUT01 = 0;
   USB.printf("# Init SPI\r\n"); wait_ms(100);
   spi.format(16,0);
   spi.frequency(50000);
   wait_ms(50);
   U_Analog1 = ain1.read()* 3.3f;
   U_Analog2 = ain2.read()* 3.3f; 
   U_Analog3 = ain3.read()* 3.3f; 
   U_Analog4 = ain4.read()* (24/0.76);; 
   U_Analog5 = ain5.read()* (5/0.76);
   USB.printf("# Analog IN: %1.2f %1.2f %1.1f %1.1f %1.1f \r\n",U_Analog1,U_Analog2,U_Analog3,U_Analog4,U_Analog5);
   wait_ms(10); 
}

//#############################################################################
// IO - Write Output
//############################################################################# 
void WR_IO()
{
   DigOUT01 = mIO.WR_Output(1,DigOUT01);       // 8 Bit 
}

//#############################################################################
// IO - Read Input Change Interrupt 
//############################################################################# 
void RD_IO()
{
   wait_ms(5);                                 // Taste entprellen !
   DigIN01  = mIO.RD_Input(0);                 // 8 Bit 
   DigIN_Change=true;
}

//#############################################################################
// US-Sensor Read - Timer Interrupt
//############################################################################# 
void GetAnalogData() 
{
  Data1[DataCnt] = ain1.read()* 3.3f*GainFactor;
  Data2[DataCnt] = ain2.read()* 3.3f*GainFactor;
  if (DataCnt<DataPoints) { DataCnt+=1; }
  led3=!led3;
  TriggerOut=led3;//!=TriggerOut;
}

//#############################################################################
// US-Sensor Read - Position Interrupt - Trinamic X-Achse
//############################################################################# 
void GetAnalogDataX()
{
  Data1[DataCnt] = ain1.read()* 3.3f*GainFactor; 
  Data2[DataCnt] = ain2.read()* 3.3f*GainFactor; 
  Coordinate[DataCnt] = 0; 
  if (DataCnt<1000) { DataCnt+=1; }
}

//#############################################################################
// US-Sensor Read - Position Interrupt - Trinamic Y-Achse
//############################################################################# 
void GetAnalogDataY()
{
  Data1[DataCnt] = ain1.read()* 3.3f*GainFactor; 
  Data2[DataCnt] = ain2.read()* 3.3f*GainFactor; 
  Coordinate[DataCnt] = 1; 
  if (DataCnt<1000) { DataCnt+=1; }
}


//#############################################################################
// DataArray Send Data
//############################################################################# 
void SendAnalogData(int anz)
{
  USB.printf("# Send Data...\r\n");wait_ms(10);
  for (int i=0;i<anz-9;i+=10) 
  { 
     for (int ii=0;ii<10;ii++) 
     { 
        USB.printf("&%1.3f %1.3f ",Data1[i+ii],Data2[i+ii]); 
     }     
     USB.printf("\r\n"); 
  }     
  USB.printf("# Messungen: %d\r\n",anz);//wait_ms(10);
}

//#############################################################################
// US-Sensor TeachInputs
//############################################################################# 
void USRes()
{ 
  US1_Gnd=false;
  US1_Pos=false; 
  US2_Gnd=false;
  US2_Pos=false; 
  US_TeachDone=true;
}

//##################################################################################
// USB Steuerbefehle vom PC ausführen
//##################################################################################
void ReadPC_Command()
{ 
   char s[20]={'\0'};
   char Header = '\0';
   char Command = '\0';
   int  CharAnz = USB.rxBufferGetCount();
   // USB.printf("# BufCnt: %d =%s\r\n",CharAnz, s);
   int digout=0;
   //int value=0; 
   double mSek =0;
   if (CharAnz>2) 
   { 
      Header = USB.getc();
      Command = USB.getc();
      USB.move(s,CharAnz-3);  
      if (Header =='%')
      {
        switch(Command) 
        { 
            case 'D':   DataAsyncSend=true;  USB.printf("# Async US_Data Start\r\n"); 
                        break;  
            case 'd':   DataAsyncSend=false; USB.printf("# Async US_Data Stopp\r\n"); 
                        break;  
            case 'o':   sscanf (s,"%d",&digout);
                        DigOUT01 = digout & 0xFF;
                        USB.printf("%%OK o%d\r\n",DigOUT01);
                        WR_IO();
                        break;  
            case 'r' :  USB.printf("!OK reset\r\n");wait_ms(100);
                        DigOUT01=0;
                        WR_IO();
                        mbed_reset();wait_ms(100);
                        break;
            case 's':   USB.printf("# Start Measurement\r\n");
                        DataAsyncSend=false;
                        DataCnt=0;
                        DataOutCnt=0;
                        AnalogDataTimer.attach_us(&GetAnalogData, AD_uSek);
                        DataSyncRunning=true;
                        break;  
            case 'p':   AnalogDataTimer.detach();
                        SendAnalogData(DataCnt);
                        break;  
            case 'a':   U_Analog1 = ain1.read()* 3.3f;
                        U_Analog2 = ain2.read()* 3.3f; 
                        U_Analog3 = ain3.read()* 3.3f; 
                        U_Analog4 = ain4.read()* (24/0.76);; 
                        U_Analog5 = ain5.read()* (5/0.76);
                        USB.printf("# Analog IN: %1.2f %1.2f %1.1f %1.1f %1.1f \r\n",U_Analog1,U_Analog2,U_Analog3,U_Analog4,U_Analog5);
                        wait_ms(10);
                        break;  
         }
      }
      if (Header =='!')
      {
        switch(Command) 
        { 
            case 't':   sscanf (s,"%lf",&mSek);
                        if (mSek<1) { mSek=1;  }
                        if (mSek>50){ mSek=50; }
                        AD_uSek = mSek*1000;
                        USB.printf("# Set to %d uSek/Mess\r\n",AD_uSek);wait_ms(100);
                        break;  
            case 'a':   USB.printf("# US-Sensor1 Cal. Max.Signal\r\n"); US1_Pos=true; US_ResetTeach.attach(&USRes,3.0); US_TeachAktiv=true;
                        break;  
            case 'b':   USB.printf("# US-Sensor1 Cal. Min.Signal\r\n"); US1_Gnd=true; US_ResetTeach.attach(&USRes,3.0); US_TeachAktiv=true;
                        break;  
            case 'c':   USB.printf("# US-Sensor2 Cal. Max.Signal\r\n"); US2_Pos=true; US_ResetTeach.attach(&USRes,3.0); US_TeachAktiv=true;
                        break;  
            case 'd':   USB.printf("# US-Sensor2 Cal. Min.Signal\r\n"); US2_Gnd=true; US_ResetTeach.attach(&USRes,3.0); US_TeachAktiv=true;
                        break;  
         }
      }
      USB.rxBufferFlush();
   }
}

int main (void) 
{
    Init_HW();
    US_ResetTeach.attach(&USRes,0.1);
    RD_IO();
    //Init_Ethernet();
    INTI2C01.fall(&RD_IO);
    //INT_TMC1.fall(&GetAnalogDataX);
    //INT_TMC2.fall(&GetAnalogDataY);
    wait_ms(200); 
    US_TeachDone=false;

    while (true)                                              // Loop    
    {  // USB Kommando ?   ######################################## 
       if (USB.rxGetLastChar()=='\n') { ReadPC_Command(); }   
       // DigIn Interupt ? ########################################
       if (DigIN_Change) { DigIN_Change=false; USB.printf("# Dig.IN: %d\r\n", DigIN01);  wait_ms(10); }
       // Send US-Data to PC ######################################
       if (DataAsyncSend)
         { // Send Async Data (100mSek)############################
           if (MainLoopCnt2<100){ MainLoopCnt2++; }
           else         
             { MainLoopCnt2=0; led2=!led2;
               DataCnt=0;
               DataOutCnt=0;
               GetAnalogData();
               USB.printf("$ %1.3f %1.3f\r\n",Data1[0],Data2[0]); 
             }
         }
       else
         { // Send Sync Data from DataArray(Timer/Interrupt)##########
           if (DataCnt>=DataOutCnt+10)        
             {  //USB.printf("# %d %d ",DataCnt,DataOutCnt);
                for (int ii=0;ii<10;ii++) 
                  { USB.printf("&%1.3f %1.3f ",Data1[DataOutCnt+ii],Data2[DataOutCnt+ii]); }     
                USB.printf("\r\n");wait_ms(10);
                DataOutCnt+=10; 
             }
         }
       // DataArray full   ########################################
       if (DataSyncRunning & DataCnt>=DataPoints)                               
         { AnalogDataTimer.detach();
           DataSyncRunning=false;
           USB.printf("# Stopp Measurement\r\n");
           led3=false;
           TriggerOut=false;
         }
       // SlowLoop (500mSek) #####################################
       if (MainLoopCnt<500){ MainLoopCnt++; }                 
       else         
         { MainLoopCnt=0; led1=!led1;
           if(US_TeachDone) { US_TeachDone=false;US_TeachAktiv=false; USB.printf("# US Teach done...\r\n", DigIN01);}
           WR_IO();
           //if (EthernetConnection) { Call_UDP_Server(); }
         }
       wait_ms(1);
    }
    
}
