#include "mbed.h"
#include "IO.h"

extern I2C I2CIO;                  // I2C DigIOs onBoard 
extern int IOBase_IOs;             // I2C DigIOs onBoard
extern SPI spi;                    // DA-Wandler  mosi, miso, sclk
 
extern DigitalOut  DAC_CS1;     // DA-Wandler  CS 
extern DigitalOut  DAC_CS2;     // DA-Wandler  CS 
extern DigitalOut  DAC_CS3;     // DA-Wandler  CS 
extern DigitalOut  DAC_CS4;     // DA-Wandler  CS 
extern DigitalOut  RS485_DE;    // RS485 DataOutEnabled

extern AnalogIn    ain1;         // 
extern AnalogIn    ain2;        // 
extern AnalogIn    ain3;        // 
extern AnalogIn    ain4;        // 

extern double U_Analog1;
extern double U_Analog2;
extern double U_Analog3;
extern double U_Analog4;

double Data1Int[100];        
double Data2Int[100];        
double Data3Int[100];
double Data4Int[100];
double Data5Int[100];


//##################################################################################
// Init_I2C_IOs
//##################################################################################
int IO::Init_I2C_IOs()
{
    char cmd[1] = {255};
    I2CIO.frequency (100000); 
    int addr = 0x01;
    addr = addr << 1;
    addr = addr + IOBase_IOs;
    cmd[0] = 255;
    I2CIO.write(addr, cmd, 1);

    addr = 0x02;
    addr = addr << 1;
    addr = addr + IOBase_IOs;
    cmd[0] = 255;
    I2CIO.write(addr, cmd, 1);

    addr = 0x00;
    addr = addr << 1;
    addr = addr + IOBase_IOs;
    cmd[0] = 0;
    I2CIO.read(addr, cmd, 1);

    int tmp = (int (cmd[0]));
    return tmp;
}

//##################################################################################
// Set_Outputs
//##################################################################################
int IO::WR_Output(int addr,char sr)
{
    addr = addr << 1;
    addr = addr + IOBase_IOs;
    char cmd[1] = {0};
    sr=~sr;
    cmd[0] += sr; 
    I2CIO.write(addr, cmd, 1);
    int tmp = (int (cmd[0]));
    tmp=~tmp;
    return tmp;
}

//##################################################################################
// RD_Inputs
//##################################################################################
int IO::RD_Input(int addr)
{
   //int addr = 0x00;
   addr = addr << 1;
   addr = addr + 0x01 + IOBase_IOs;
   char cmd[1] = {0x0};
   I2CIO.read(addr, cmd, 1);
   int tmp = (int (cmd[0]));
   tmp=~tmp;
   return tmp;
}

//#############################################################################
// DA-Wandler A
//#############################################################################
void IO::WR_DARegA(int v)
{
   v = v & 0x0FFF; 
   int word = v | 0x1000; // x2
   DAC_CS1 = false; 
   wait_us(100);
   spi.write(word); 
   wait_us(100);
   DAC_CS1 = true;
}

//##################################################################################
// DA-Wandler B 
//##################################################################################
void IO::WR_DARegB(int v)
{
   v = v & 0x0FFF; 
   int word = v | 0x9000; // x2   A-GS109876543210
   DAC_CS1 = false;
   wait_us(100);
   spi.write(word); 
   wait_us(100);
   DAC_CS1 = true;
}

//#############################################################################
// meanValue 
//############################################################################# 
double meanValue(double *samples, int n) 
{
    double sum = 0.0;
    for (int i=0; i<n; i++) { sum += samples[i]; }
    return sum / (double)n;
}

double maxValue(double *samples, int n) 
{
    double max = 0.0;
    for (int i=0; i<n; i++) 
    {
        if (samples[i]>max) { max=samples[i]; }
    }
    return max;
}

//#############################################################################
// LED-Strom, Externer Sollwert, Lichtmengen-Messung (Kalibrierung)
//#############################################################################
void IO::GetAnalogValues()
{  int anz=50;
   for (int x=anz-1;x>0;x--) { Data1Int[x]=Data1Int[x-1]; }
   Data1Int[0]= ain1.read()* 3.3f; 
   U_Analog1 = meanValue(Data1Int,anz);
   
   for (int x=anz-1;x>0;x--) { Data2Int[x]=Data2Int[x-1]; }
   Data2Int[0]= ain2.read()* 3.3f; 
   U_Analog2 = meanValue(Data2Int,anz);
   
   for (int x=anz-1;x>0;x--) { Data3Int[x]=Data3Int[x-1]; }
   Data3Int[0]= ain3.read()* 3.3f; 
   U_Analog3 = meanValue(Data3Int,anz);
   
   for (int x=anz-1;x>0;x--) { Data4Int[x]=Data4Int[x-1]; }
   Data4Int[0]= ain4.read()* 3.3f; 
   U_Analog4 = meanValue(Data4Int,anz);
}

//#####################################################################################
// Save_Parameter
//#####################################################################################
void IO::Save_Parameter()
{
    FILE *fp = fopen("/local/Config.dat", "w");  // Open the local file system for writing
    //  fprintf(fp,"USB  : %1d\r\n",USBon); 
    //  fprintf(fp,"RS232: %1d\r\n",RS_on); 
    fclose(fp);
}

//#####################################################################################
// Load_Parameter
//#####################################################################################
void IO::Load_Parameter()
{
    int c;
    int ti;
    FILE *fp = fopen("/local/Config.dat", "r");  // Open the local file system for reading
    if(fp==NULL) { Save_Parameter(); }
    else
    {
      do { c = fgetc (fp); } 
      while (c != ':' && c != EOF);
      fscanf(fp,"%d",&ti); 
      // USBon=ti;
      do { c = fgetc (fp); } 
      while (c != ':' && c != EOF);
      fscanf(fp,"%d",&ti); 
      // RS_on=ti;
      fclose(fp);
    }
}

