//#include "EthernetInterface.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "mbed.h"
#include "rtos.h" // need for main thread sleep
#include "html.h" // need for html patch working with web server
#include "bloc_io.h"
#define RADIUS  0.2F // wheel size
#define NBPOLES 8 // magnetic pole number
#define DELTA_T 0.1F // speed measurement counting period
#define PI 3.14F // PI
#define SensibiliteTemp 0.01F // doc
#define CoeffTensionbat 77.5F // determiner manuellemnt
#define SensibiliteCourant 0.185F // doc ACS712
#define batt 2 // 2 A pendant 1 minute Jauge d'energie capacité
#define itest 0.0333  // A*minutes
#define PDTI 1.85F // 33/(28+33)*3.3 = 1.85
#define cstCAN 0.001


DigitalOut PWM_VALID (p21);
InterruptIn TopHall (p22);// valid pmw mbed pin
AnalogIn POIGNEE (p17); // broche poignee
AnalogIn Temp(p19); // broche temperature
AnalogIn Vbat(p18);// analog input connected to mbed
AnalogIn Ibat(p20); // broche courant batterie
Bloc_IO MyPLD(p25,p26,p5,p6,p7,p8,p9,p10,p23,p24);// instantiate object needed to communicate with PLD
Serial pc(USBTX, USBRX);// tx, rx

void PWM ();
void Mesure();
void CalculV ();
void saveFile();//sauvegarde fichier
void MesureTemp(void);
void MesureVbat(void);
void MesureIbat(void);
void Mesurepoingnee(void); // pourcentage POIGNEE
void MesuresWeb(void);
void Receive ();

int iCounter1Sec;
Ticker T_Mesures;
Ticker AUTO;
Ticker CalculVitesse;
float GazMax, GazMin, caparestante;
int pwmmanuel,x,Overcurrent,Brake,FLTA,Direction,HALLC,HALLB,HALLA;
char cChoix;
int pwm_final=0;
int valpwm=0;
int mode=0;
float vitesse;
int tophall;
int tophalltotal;
int vitesssebride;
float vitessemesure;
float vitessebride = 25.0;
int tophallpartiel;
float temp,vbat, ibat, pourcentage;
float batterieAc = 0.0;
int a; // bus CAN
float valpoignee; //bus CAN


// UTILISATION DU BUS CAN ENVOIE
Ticker ticker;
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3); // blink when can message is sent
DigitalOut led4(LED4); // blink when can message is received

char counter = 0;

// Top_Hall Pin

/************ persistent file parameters section *****************/
LocalFileSystem local("local");// Create the local filesystem under the name "local"


/********************* web server section **********************************/

var_field_t tab_balise[10];  //une balise est présente dans le squelette
int giCounter=0;// acces counting



/*********************** can bus section  ************/
// determine message ID used to send Gaz ref over can bus
#define _CAN_DEBUG // used to debug can bus activity
#define USE_CAN_REF // uncomment to receive gaz ref over can_bus
CAN can_port (p30, p29); // initialisation du Bus CAN sur les broches 30 (rd) et 29(td) for lpc1768 + mbed shield
bool bCan_Active=false;


//DigitalOut led1(LED1); //initialisation des Leds présentes sur le micro-controleur Mbed*/
//DigitalOut led2(LED2);
//DigitalOut led3(LED3); // blink when can message is sent
//DigitalOut led4(LED4); // blink when can message is received




//************ local function prototypes *******************
/**************** Read persistent data from text file located on local file system ****************/
/**************** write persitant  data to text file located on local file system ****************/

void saveFile()
{
    FILE *fp = fopen("/local/gr1.txt", "w");
    if(fp != NULL) fprintf(fp,"valeur max : %f, valeur min: %f, tophalltotal: %d, vitesse de la bride: %f, tophallpartiel:%d, capacite restante: %f",GazMin,GazMax,tophalltotal,vitessebride,tophallpartiel,caparestante);
    else printf("ERREUR FICHIER NON VALIDE");
    fclose(fp);

}

//************** calibation gaz function needed to record min_gaz and max_gaz value to persistent text file  ******************


// ************top hall counting interrupt needed for speed measurement


//********************** timer interrupt for speed measurement each 100ms  *************************


//********************* Timer Interrupt for gaz ref management each 10ms   ********************


/********* main cgi function used to patch data to the web server thread **********************************/


void CGI_Function(void) // cgi function that patch web data to empty web page
{
    char ma_chaine4[20]= {}; // needed to form html response

    sprintf (ma_chaine4,"%f",vitessemesure);
    printf("chaine4=%s\n",ma_chaine4);
    Html_Patch (tab_balise,0,ma_chaine4);

    sprintf (ma_chaine4,"%f",vitessemesure);
    printf("chaine4=%s\n",ma_chaine4);
    Html_Patch (tab_balise,1,ma_chaine4);

    sprintf (ma_chaine4,"%d",(int)((valpwm*100 )/ 255));
    printf("chaine4=%s\n",ma_chaine4);
    Html_Patch (tab_balise,2,ma_chaine4);

    sprintf (ma_chaine4,"%f",(temp-273.15));
    printf("chaine4=%s\n",ma_chaine4);
    Html_Patch (tab_balise,3,ma_chaine4);

    sprintf (ma_chaine4,"%f",vbat);
    printf("chaine4=%s\n",ma_chaine4);
    Html_Patch (tab_balise,4,ma_chaine4);

    sprintf (ma_chaine4,"%f",ibat);
    printf("chaine4=%s\n",ma_chaine4);
    Html_Patch (tab_balise,5,ma_chaine4);

}


/*********************** CAN BUS SECTION  **********************/

void CAN_REC_THREAD(void const *args)
{
    int iCount,iError;

    while (bCan_Active) {
        Thread::wait(100);// wait 100ms
        // code todo

    }
}

void Receive()
{
    CANMessage msg;
    if(can_port.read(msg)) {
    
    valpoignee=*reinterpret_cast<int*>(msg.data)*cstCAN;
    }
}
//*************************** main function *****************************************
int main()
{

    caparestante = (batterieAc*100)/(batt);
    MyPLD.write(0);
    PWM_VALID.write(1);
    char carac;
    FILE *fp = fopen("/local/gr1.txt", "r");
    if(fp != NULL) {
        fscanf(fp,"valeur max : %f, valeur min: %f, tophalltotal: %d, vitesse de la bride: %f, tophallpartiel:%d, capacite restante: %f",&GazMin,&GazMax,&tophalltotal,&vitessebride,&tophallpartiel,&caparestante);
        printf("Valeur min:%f , Valeur max:%f ,tophalltotal:%d,vitesse de la bride:%f,tophallpartiel:%d, capacite restante: %f\n\r",GazMin,GazMax,tophalltotal,vitessebride,tophallpartiel,caparestante);
    } else
        printf("ERREUR FICHIER NON VALIDE\n\r");
    fclose(fp);

//***************************************** web section ********************************************/



    Init_Web_Server(&CGI_Function); // create and initialize tcp server socket and pass function pointer to local CGI function
    Thread WebThread(Web_Server_Thread);// create and launch web server thread
    Gen_HtmlCode_From_File("/local/tintin.htm",tab_balise,5);
    /********* main cgi function used to patch data to the web server thread **********************************/

//******************************************* end web section  ************************************* /






//********************* can bus section initialisation *******************************************
//bCan_Active=true;// needed to lauchn CAN thread
//Thread CanThread(CAN_REC_THREAD);// create and launch can receiver  thread
//********************* end can bus section *****************************************************
    can_port.attach(&Receive,CAN::RxIrq);
    TopHall.mode(PullUp);
    AUTO.attach(&PWM,0.02);
    TopHall.rise(&Mesure);
    CalculVitesse.attach(&CalculV,0.1);
    T_Mesures.attach(&MesuresWeb,0.1);
    pc.printf("programme scooter mbed \n\r");
    while(cChoix!='q' and cChoix!='Q') {
        pc.printf("Veuillez saisir un choix parmi la liste proposee:\n\r");
        pc.printf("a:saisie consigne pwm\n\r");
        pc.printf("b:Calibration poignee\n\r");
        pc.printf("d:Mode automatique\n\r");
        pc.printf("e:Lecture du registre interne\n\r");
        pc.printf("f:Mesure de la vitesse\n\r");
        pc.printf("g: Saisie bride\n\r");
        pc.printf("h: Lecture vitesse\n\r");
        pc.printf("i: Compteur kilometrique\n\r");
        pc.printf("j: RAZ compteur partiel\n\r");
        pc.printf("k: Valeur de la temperature\n\r");
        pc.printf("l: rechargement batterie\n\r");
        pc.printf("z: BUS CAN \n\r");
        pc.printf("q:quitter\n\r");

        //************* multithreading : main thread need to sleep in order to allow web response */
        while (pc.readable()==0) { // determine if char availabler
            Thread::wait(10);   // wait 10 until char available on serial input
        }
        /************* end of main thread sleep  ****************/
        pc.scanf("%c",&cChoix);
        switch (cChoix) {
            case 'a': // COMMANDE MANUEL
                mode=1;
                printf("veuillez entrer une valeur de PWM entre 0 et 255\n\r");
                scanf("%d",&pwmmanuel);
                break;
            case 'b': // CALIBRATION DE LA POIGNEE DE GAZ (VALEUR MIN ET MAX)
                AUTO.detach();
                PWM_VALID.write(0);
                if (PWM_VALID.read()==0) MyPLD.write(0);
                printf("Veuillez entrer n'importe quel caractere si vous etes OK pour la valeur min\n\r");
                scanf("%c",&carac);
                GazMin=POIGNEE.read();
                printf("\n\r");
                printf("Veuillez entrer n'importe quel caractere si vous etes OK pour la valeur max\n\r");
                scanf("%c",&carac);
                GazMax=valpoignee;
                printf("\n\r");
                printf("Valeur de la poignee min:%g\n\r",GazMin);
                printf("Valeur de la poignee max:%g\n\r",GazMax);
                saveFile();
                break;
            case 'd':// MODE AUTOMATIQUE
                mode=0;
                break;
            case 'e':
                x=MyPLD.read();
                Overcurrent= (x & 64)/64 ; //Technique pour avoir la valeur en binaire
                Brake= (x & 32)/32;
                FLTA=(x & 16)/16;
                Direction=(x & 8)/8;
                HALLC=(x & 4)/4;
                HALLB=(x & 2)/2;
                HALLA= x & 1;
                int hall=0;
                if (HALLA == 1) {
                    hall++;
                }
                if (HALLB == 1) {
                    hall+=2;
                }
                if (HALLC == 1) {
                    hall+=4;
                }
                pc.printf("hall=%d\r\n", hall);
                if (Overcurrent == 0) {
                    printf("Surintensite dans le moteur\n\r ");
                } else {
                    printf( "Pas de surintensite dans le moteur\n\r");
                }

                if (Brake == 1) {
                    printf("Frein desactive\n\r");
                } else {
                    printf( "Frein active\n\r");
                }

                if (FLTA == 1) { // verifier s'il n'y a pas de registre interne
                    printf("pas erreur registre interne\n\r");
                } else {
                    printf( "erreur registre interne \n\r");
                }

                if (Direction == 1) {
                    printf("marche avant active\n\r");
                } else {
                    printf( "marche avant desactive\n\r");
                }
                break;
            case 'f': // VITESSE DE LA ROUE DU SCOOT
                printf("vitesse de la roue: %f\n\r",vitesse);
                break;
            case 'g': // SAISIE DE LA BRIDE
                printf("Veuillez saisir la valeur de la bride entre 0 et 30 km/h \n\r");
                scanf("%f",&vitessebride);
                saveFile();
                printf("Valeur de la bride \n\r",vitessebride);
                break;
            case 'h': // VITESSE DE LA ROUE DU SCOOT
                printf("Vitesse:%1.3f km/h \n\r",vitessemesure*3.6);
                break;
            case 'i': // DISTANCE DE LA ROUE TOTAL ET PARTIEL
                printf("Distance parcourue totale: %f metres\n\r",(tophalltotal*2*PI*RADIUS)/(6*NBPOLES));
                printf("Distance parcourue partielle: %f metres\n\r",(tophallpartiel*2*PI*RADIUS)/(6*NBPOLES));
                break;
            case 'j': // REMISE A ZERO DU COMPTEUR PARTIEL
                printf("Appuyez sur n'importe quel caractere pour remettre a zero le compteur partiel\n\r");
                scanf("%c",&carac);
                tophallpartiel=0;
                saveFile();
                break;
            case 'k': //VALEUR DE LA TEMPERATURE , TENSION BATTERIE, COURANT , POURCENTAGE POINGNEE ,JAUGE D'ENERGIE

                MesureTemp();
                MesureVbat();
                MesureIbat();
                Mesurepoingnee();
                printf("l'intensite de la batterie est de %1.3fA et jauge d'energie = %f pourcentage\n\r", ibat,(batterieAc*100)/(batt) );
                break;
            case 'l':
                batterieAc = batt;
                printf("batterie rechargee\n\r");
                break;
            case 'q': // QUITTER LE PROGRAMME
                AUTO.detach();
                CalculVitesse.detach();
                PWM_VALID.write(0);
                if (PWM_VALID.read()==0) MyPLD.write(0);
                printf("BYE");
                break;
                
            case 'z': //VALEUR CAN
                printf("valeur recu CAN : %f\n\r", valpoignee);
                break;
        }
        saveFile();
        pc.printf("fin programme scooter mbed\n\r");
    } // end while
}
//************** thread deinit *********************

//DeInit_Web_Server();
//bCan_Active=false;
//CanThread=false;// close can received thread




// END MAIN
void PWM()
{
    Receive();
    x=MyPLD.read();
    Brake= (x & 32)/32;


    iCounter1Sec++;

    if (iCounter1Sec == 50) { // compteur 1 seconde
        iCounter1Sec= 0;
        MesureIbat();
        batterieAc = batterieAc-0.0333; // utiliser le courant

        if (batterieAc < 0) {
            batterieAc = 0 ;
        }
    }

    if (mode==1) { // MODE MANUEL
        MyPLD.write(0);
        if (pwmmanuel > 0 && pwmmanuel <=255) {

            PWM_VALID.write(1);
            MyPLD.write(pwmmanuel);
        }
    } else if(mode==0) {// mode automatique

        if ( Brake == 0 ) { //frein actif
            MyPLD.write(0);
            pwm_final=0;
        } else if ( Brake == 1 ) { // frein désactif

            valpwm =(255/(GazMax-GazMin))*valpoignee-(255/(GazMax-GazMin))*GazMin; // calcul de la PWM brute
        }

        if ((vitessemesure *3.6) > vitessebride) { // VITESSE MESURE
            pwm_final-=1;
        } else {

            if (pwm_final<valpwm) {  // test pwm final (gestion progressive)

                pwm_final+= 1;

            } else pwm_final=valpwm;

            if (pwm_final>255) { //limitation pwm final
                pwm_final=255;
            }
            if(pwm_final<0) { //limitation
                pwm_final=0;
            }
        }
        MyPLD.write(pwm_final);
    }
}
void Mesure ()
{
    tophall++; //incrémentation nombre de pôle;
}
void CalculV ()
{
    int hall = tophall;
    vitessemesure=(hall*2*PI*RADIUS)/(6*NBPOLES*DELTA_T);
    tophalltotal += tophall;
    tophallpartiel += tophall;
    tophall=0;
}
void MesureTemp ()
{
    temp = (Temp.read()*3.3 )/ SensibiliteTemp;
    printf("la temperature est de %1.3f KELVIN equivaut a %1.3f DEGRES\n\r",temp, temp-273.15);
}

void MesureVbat ()
{
    vbat = Vbat.read()*CoeffTensionbat;
    printf("la tension de la batterie est de %1.3f volts\n\r", vbat );
}
void MesureIbat ()
{
    ibat = ((Ibat.read()*3.3*PDTI)-2.5)/SensibiliteCourant;
    if (ibat < 0) {
        ibat = 0;
    }


}
void Mesurepoingnee()
{
    pourcentage = (valpwm*100 )/ 255;
    printf("valeur pourcentage poignee %g  \n\r", pourcentage);

}

void MesuresWeb(void)
{
    temp = (Temp.read()*3.3 )/ SensibiliteTemp;
    vbat = Vbat.read()*CoeffTensionbat;
    ibat = ((Ibat.read()*3.3*PDTI)-2.5)/SensibiliteCourant;
    if (ibat < 0) {
        ibat = 0;
    }
}