#include "client.h"
/* ethernet */
#include <EthernetInterface.h>

// Network interface
EthernetInterface net;

int init_nw() {
   printf("%s\n", __FUNCTION__);
   net.connect();
   // Show the network address
   const char *ip = net.get_ip_address();
   printf("IP address is: %s\n", ip ? ip : "No IP");
   return 0;
}

int desinit_nw() {
    printf("%s\n", __FUNCTION__);
    // Bring down the ethernet interface
    net.disconnect();
    printf("Done\n");
    return 0;
}

// Socket demo
int send_data(/* TODO */) {

    // Open a socket on the network interface, and create a TCP connection to mbed.org
    TCPSocket socket;
    socket.open(&net);
    socket.connect("developer.mbed.org", 80);

    // Send a simple http request
    char sbuffer[] = "GET / HTTP/1.1\r\nHost: developer.mbed.org\r\n\r\n";
    int scount = socket.send(sbuffer, sizeof sbuffer);
    printf("sent %d [%.*s]\n", scount, strstr(sbuffer, "\r\n")-sbuffer, sbuffer);

    // Recieve a simple http response and print out the response line
    char rbuffer[64];
    int rcount = socket.recv(rbuffer, sizeof rbuffer);
    printf("recv %d [%.*s]\n", rcount, strstr(rbuffer, "\r\n")-rbuffer, rbuffer);

    // Close the socket to return its memory and bring down the network interface
    socket.close();
    
    return 0;

}


int send_data2(const int distance) {

    // Open a socket on the network interface, and create a TCP connection to mbed.org
    TCPSocket socket;
    socket.open(&net);
    socket.connect("192.168.1.67", 3000);

    // Send a simple http request
    char sbuffer[256];
    snprintf(sbuffer, 256, "POST /?distance=%d HTTP/1.1\r\n\r\n\r\n", distance);
    int scount = socket.send(sbuffer, sizeof sbuffer);
    printf("sent %d [%.*s]\n", scount, strstr(sbuffer, "\r\n")-sbuffer, sbuffer);

    // Recieve a simple http response and print out the response line
    char rbuffer[64];
    int rcount = socket.recv(rbuffer, sizeof rbuffer);
    printf("recv %d [%.*s]\n", rcount, strstr(rbuffer, "\r\n")-rbuffer, rbuffer);

    // Close the socket to return its memory and bring down the network interface
    socket.close();
    
    return 0;

}