#include "radar.h"
#include "client.h"

/* local function declarations */
void dist(int distance);

/* variable(s) definition(s) */
int volatile position=RANGE_NONE;
ultrasonic mu(PB_8, PB_9, .1, 1, &dist);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
// Global flip count variable
int volatile flipcount=0;

DigitalOut led4(PC_6); // external LED or buzzer
//PinDetect pb(PC_13);
Ticker flipper;

/* function(s) definition(s) */
void dist(int distance)
{
    //put code here to execute when the distance has changed
    printf("Distance %d mm\r\n", distance);
    send_data2(distance);
    if (distance < 300) position = RANGE_CLOSE;
    else if (distance < 600) position = RANGE_MID;
    else if (distance < 1000) position = RANGE_FAR;
    else position = RANGE_NONE;
    
    led3 = (position >= RANGE_CLOSE);
    led2 = (position >= RANGE_MID);
    led1 = (position >= RANGE_FAR);
}


void flip() {
    if(RANGE_NONE == position) {
        led4 = 0;
        return;
    }
    flipcount++;
    flipcount = flipcount % (RANGE_MAX - position);
    if(flipcount == 0) {
        led4 = !led4;
    }
}

// run a radar forever
void radar() {
    //start measuring the distance
    mu.startUpdates();
    // the address of the function to be attached (flip) and the interval (2 seconds)
    flipper.attach(&flip, 0.2); 
 
    while(1)
    {
        //Do something else here
        mu.checkDistance();     //call checkDistance() as much as possible, as this is where
                                //the class checks if dist needs to be called.
    }
}