#include "mbed.h"
 
// See if a screen is connected


I2C i2c(p28, p27);

const int addr = 0x78;

void WriteInst(char byInst)
{
    char cmd[3];
    cmd[0] = 0x78;
    cmd[1] = 0x00;
    cmd[2] = byInst;
    i2c.start();
    i2c.write(addr, cmd, 3);
    i2c.stop();
}

void WriteData(char byData)
{
    char cmd[3];
    cmd[0] = 0x78;
    cmd[1] = 0x40;
    cmd[2] = byData;
    i2c.start();
    i2c.write(addr, cmd, 3);
    i2c.stop();
}

void InitRW1063(void)
{
    WriteInst(0x38); //DL=1: 8 bits; N=1: 2 line; F=0: 5 x 8dots 
    WriteInst(0x0c); // D=1, display on; C=B=0; cursor off; blinking off; 
    WriteInst(0x06); // I/D=1: Increment by 1; S=0: No shift
}
 
int main() {
    wait(0.1);
    InitRW1063();
    
    while (1) {
    }
}