/*

Copyright (c) 2012-2014 RedBearLab

Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
and associated documentation files (the "Software"), to deal in the Software without restriction, 
including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, 
and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, 
subject to the following conditions:
The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE 
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#include "mbed.h"
#include "ble/BLE.h"
#include "Servo.h"


#define TXRX_BUF_LEN               20

#define PIN_TIME_MORE                  P0_4
#define PIN_TIME_LESS                  P0_5
#define PIN_DOUGH_QNT                  P0_8
#define PIN_OPTIONS                    P0_9
#define PIN_COLOR                      P0_10
#define PIN_INIT_STOP                  P0_11
#define PIN_TEST_LED                   P0_19 // only used for debuggin (visual check)

#define OPERATION                      0x00
#define COMMAND                        0x01
#define PROGRAM                        0x02

#define TIME_MORE                  0x04
#define TIME_LESS                  0x05
#define DOUGH_QNT                  0x02
#define INIT_STOP                  0x06
#define OPTIONS                    0x01
#define COLOR                      0x03
#define TEST_LED                   0x07 

#define DELAY                      250 // 250 ms holding the up state for button clicking

BLE             ble;

DigitalOut      time_more(PIN_TIME_MORE,0);
DigitalOut      time_less(PIN_TIME_LESS,0);
DigitalOut      dough_qnt(PIN_DOUGH_QNT,0);
DigitalOut      init_stop(PIN_INIT_STOP,0);
DigitalOut      options(PIN_OPTIONS,0);
DigitalOut      color(PIN_COLOR,0);
DigitalOut      test_led(PIN_TEST_LED,1);

/* The Nordic UART Service */

// RX_SERVICE_UUID do APP Android
static const uint8_t uart_base_uuid[] = {0x6E, 0x40, 0x00, 0x01, 0xB5, 0xA3, 0xF3, 0x93, 0xE0, 0xA9, 0xE5, 0x0E, 0x24, 0xDC, 0xCA, 0x9E};
//TX_CHAR_UUID do APP Android
static const uint8_t uart_tx_uuid[]   = {0x6E, 0x40, 0x00, 0x02, 0xB5, 0xA3, 0xF3, 0x93, 0xE0, 0xA9, 0xE5, 0x0E, 0x24, 0xDC, 0xCA, 0x9E};
//RX_CHAR_UUID do APP Android
static const uint8_t uart_rx_uuid[]   = {0x6E, 0x40, 0x00, 0x03, 0xB5, 0xA3, 0xF3, 0x93, 0xE0, 0xA9, 0xE5, 0x0E, 0x24, 0xDC, 0xCA, 0x9E};
// RX_SERVICE_UUID do APP Android
static const uint8_t uart_base_uuid_rev[] = {0x6E, 0x40, 0x00, 0x01, 0xB5, 0xA3, 0xF3, 0x93, 0xE0, 0xA9, 0xE5, 0x0E, 0x24, 0xDC, 0xCA, 0x9E};


uint8_t txPayload[TXRX_BUF_LEN] = {0,};
uint8_t rxPayload[TXRX_BUF_LEN] = {0,};

//static uint8_t rx_buf[TXRX_BUF_LEN];
//static uint8_t rx_len=0;


GattCharacteristic  txCharacteristic (uart_tx_uuid, txPayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE);
                                      
GattCharacteristic  rxCharacteristic (uart_rx_uuid, rxPayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);
                                      
GattCharacteristic *uartChars[] = {&txCharacteristic, &rxCharacteristic};

GattService         uartService(uart_base_uuid, uartChars, sizeof(uartChars) / sizeof(GattCharacteristic *));



void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    //pc.printf("Disconnected \r\n");
    //pc.printf("Restart advertising \r\n");
    //ble.gap().startAdvertising();
    ble.startAdvertising();
}

void ClickButton(DigitalOut *button, uint8_t *click_num)
{
    for (uint8_t i = *click_num; i > 0; i--)
    {
        *button = 0;
        wait_ms(DELAY);
        *button = 1;
        wait_ms(DELAY);
        *button = 0;
    }
}

void WrittenHandler(const GattWriteCallbackParams *Handler)
{   
    uint8_t buf[TXRX_BUF_LEN];
    uint16_t bytesRead;
    
    if (Handler->handle == txCharacteristic.getValueAttribute().getHandle()) 
    {
        ble.readCharacteristicValue(txCharacteristic.getValueAttribute().getHandle(), buf, &bytesRead);
        memset(txPayload, 0, TXRX_BUF_LEN);
        memcpy(txPayload, buf, TXRX_BUF_LEN);       
        
        switch (buf[OPERATION]) {
            case COMMAND:
                options = buf[OPTIONS];
                dough_qnt = buf[DOUGH_QNT];
                color = buf[COLOR];
                time_more = buf[TIME_MORE];
                time_less = buf[TIME_LESS];
                init_stop = buf[INIT_STOP];
            break;
            case PROGRAM:            
                ClickButton(&options,&buf[OPTIONS]);
                ClickButton(&dough_qnt, &buf[DOUGH_QNT]);
                ClickButton(&color, &buf[COLOR]);
                ClickButton(&time_more, &buf[TIME_MORE]);
                ClickButton(&time_less, &buf[TIME_LESS]);
                ClickButton(&init_stop, &buf[INIT_STOP]);          
            break;
        }
    }
}
/*
void uartCB(void)
{   
    while(pc.readable())    
    {
        rx_buf[rx_len++] = pc.getc();    
        if(rx_len>=20 || rx_buf[rx_len-1]=='\0' || rx_buf[rx_len-1]=='\n')
        {
            ble.updateCharacteristicValue(rxCharacteristic.getValueAttribute().getHandle(), rx_buf, rx_len); 
            pc.printf("RecHandler \r\n");
            pc.printf("Length: ");
            pc.putc(rx_len);
            pc.printf("\r\n");
            rx_len = 0;
            break;
        }
    }
}
*/
void m_status_check_handle(void)
{   
    /*
    uint8_t buf[3];
    if (analog_enabled)  // if analog reading enabled
    {
        // Read and send out
        float s = ANALOG;
        uint16_t value = s*1024; 
        buf[0] = (0x0B);
        buf[1] = (value >> 8);
        buf[2] = (value);
        ble.updateCharacteristicValue(rxCharacteristic.getValueAttribute().getHandle(), buf, 3); 
    }
    
     If digital in changes, report the state
    if (BUTTON != old_state)
    {
        old_state = BUTTON;
        
        if (BUTTON == 1)
        {
            buf[0] = (0x0A);
            buf[1] = (0x01);
            buf[2] = (0x00);    
            ble.updateCharacteristicValue(rxCharacteristic.getValueAttribute().getHandle(), buf, 3); 
        }
        else
        {
            buf[0] = (0x0A);
            buf[1] = (0x00);
            buf[2] = (0x00);
           ble.updateCharacteristicValue(rxCharacteristic.getValueAttribute().getHandle(), buf, 3); 
        }
    }
    */
}


int main(void)
{   
    Ticker ticker;
    ticker.attach_us(m_status_check_handle, 200000);
    
    ble.init();
    ble.onDisconnection(disconnectionCallback);
    ble.onDataWritten(WrittenHandler);  
    
    //pc.baud(9600);
    //pc.printf("SimpleChat Init \r\n");

    //pc.attach( uartCB , pc.RxIrq);
    
    // setup advertising 
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                    (const uint8_t *)"Panificadora", sizeof("Panificadora") - 1);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,
                                    (const uint8_t *)uart_base_uuid_rev, sizeof(uart_base_uuid));
    // 100ms; in multiples of 0.625ms. 
    ble.setAdvertisingInterval(160);

    ble.addService(uartService);
    
    ble.startAdvertising(); 
    
    //pc.printf("Advertising Start \r\n");
   
    while(1)
    {
        ble.waitForEvent(); 
    }
}































