/* ---------------------------------------------------------------------------
** This software is in the public domain, furnished "as is", without technical
** support, and with no warranty, express or implied, as to its usefulness for
** any purpose.
**
** main.ccp
** NodeMCU module with STM32F401RE Nucleo Board
** Author: <veyselka@hotmail.com> <v.karadag@gmail.com> Veysel KARADAG
** USB PC for systemout
** NodeMCU is Connected to PA9 , PA10
** PA_6 is Output for RESET NODEMCU
** Thanks sam grove for Buffered Serial Lib.
** USER button is using Interrupt and Toggle LED1 ( For TESTING INTERRUPT ISSUE )
** -------------------------------------------------------------------------*/


#include "mbed.h"
#include "rtos.h"
#include "BufferedSerial.h"
#include "esp8622.h"
#include "wifi.h"

  

BufferedSerial pc(USBTX, USBRX);

InterruptIn button(USER_BUTTON);
DigitalOut myled(LED1);
DigitalOut wifiRST(PA_6);



void WIFI(void const *args);
void SYSTEM(void const *args);
void button_pressed(void);




int main()
{
    button.fall(&button_pressed);
    pc.baud(115200);

    printf("\r\nNODEMCU AT COMMAND TEST APP\r\n");

    
    Thread WIFI_THREAD(WIFI,NULL,osPriorityNormal,1024);
    Thread SYSTEM_THREAD(SYSTEM,NULL,osPriorityNormal,128);

    
    while(1);



}

void WIFI(void const *args) {
 
    int attest=0;
    int taskcnt=0;
    
    char my_ip[32];
    char st_ip[32];
    
    char data[32];
    
     
        
    // WIFI MODUL RESTART// 
    
    Thread::wait(1000);
    wifiRST = 0;
    Thread::wait(1000);
    wifiRST = 1;
   
    while(true) {
      
    // Read a line from the large rx buffer from rx interrupt routine
        
        while(attest==0){
            
            Thread::wait(1000);
            attest=at_TEST();
            printf("AT TEST:%d\r\n",attest);
            Echo_OFF();
            printf("ECHO OFFd\r\n");
        }
        
        while(1){
            
            Thread::wait(1000);
            connectRouter("veysel","12345678"); 
            Thread::wait(6000);
            
            read_ip(my_ip,st_ip);
            printf("MY IP:%s\r\n",my_ip);
            printf("ST IP:%s\r\n",st_ip);
            
            int datacnt=0;
            
            Thread::wait(1000);
            while(1){
                
                read_ip(my_ip,st_ip);
                printf("MY IP:%s\r\n",my_ip);
                printf("ST IP:%s\r\n",st_ip);
               
                if( strlen(my_ip)>6  && strlen(my_ip)>6 ){
                    
                
                    
                    sprintf(data,"Hello World %d\r\n",datacnt++);
                    
                    if( send_SOC_DATA("192.168.11",28800,data)==1){   // USE YOUR SERVER and IP
                        
                        printf("DATA SENDED\r\n");
                            
                    }else{
                        
                        printf("DATA SEND ERROR\r\n");
                    }
    
                }
                
                
                
                Thread::wait(1000);
            }
                
         
                   
                
        }


        printf("Round:%d\r\n",taskcnt++);
      

       
    }
}


void SYSTEM(void const *args) {


    while(true) {
    
        Thread::wait(1000); 
        
    }
}



void button_pressed()
{
 

    printf("Button Pressed\r\n");
    myled = !myled;
    wifiRST = !wifiRST;
}

