/* ---------------------------------------------------------------------------
** This software is in the public domain, furnished "as is", without technical
** support, and with no warranty, express or implied, as to its usefulness for
** any purpose.
**
** wifi.ccp
** NodeMCU at Commands
** Author: <veyselka@hotmail.com> <v.karadag@gmail.com> Veysel KARADAG
** -------------------------------------------------------------------------*/

#include "esp8622.h"
#include "mbed.h"
#include "wifi.h"
#include "rtos.h"


esp8622 esp(PA_9, PA_10,9600);


/*******************************************************************************
* Function Name  : connectRouter
* Description    : Connect NodeMCU to WIFI Router / AP
* Input          : SSID, PASSWORD
* Output         : NONE
* Return         : 1-COnnected 0-NOT CONCECTED
*******************************************************************************/

int connectRouter(char *ssid, char *password ){
 

    char cmd[32];
    
    esp.sendCmd("AT+CWMODE=3\r\n");

    Thread::wait(100);
    
    sprintf(cmd,"AT+CWJAP=\"%s\",\"%s\"\r\n",ssid,password);
    
    esp.sendCmd(cmd);
    
    memset(cmd,0,32);
    esp.readFromBuffer(cmd,DEFAULT_TIMEOUT,10);

    if(strncmp(cmd,"AT\r\r\n\r\nOK",9)==0)
        return 1;
    else
        return 0;
   
}


/*******************************************************************************
* Function Name  : at_TEST
* Description    : SEND Modem AT and CHECK RESPONSE
* Input          : NONE
* Output         : NONE
* Return         : 1-TESTED 0-FAILED
*******************************************************************************/

int at_TEST(void){
    
    return esp.sendATTest();    
        
}

/*******************************************************************************
* Function Name  : read_ip
* Description    : READ MODEM STA IP and, IP
* Input          : IP & STA_IP
* Output         : IPi STA_IP
* Return         : NONE always 1
*******************************************************************************/
int read_ip(char *ip , char *sta_ip ){
    
    char rx_buffer[64];
    char *token;
    
   
    memset(rx_buffer,0,64); 
     
        
    esp.sendCmd("AT+CIFSR\r\n");
    
    esp.readFromBuffer(rx_buffer,DEFAULT_TIMEOUT,64);
    
    printf("CMD:%s:\r\n",rx_buffer);
        
    token = strtok (rx_buffer,"\n");
    sprintf(ip,"%s",token);
    remove_all_chars(ip,'\r');
    
    token = strtok (NULL,"\n");
    sprintf(sta_ip,"%s",token);
    remove_all_chars(sta_ip,'\r');
    
    return 1;
}



/*******************************************************************************
* Function Name  : remove_all_chars
* Description    : remove char c in string..
* Input          : Data
* Output         : None
* Return         : NONE
*******************************************************************************/

void remove_all_chars(char* str, char c) {
    char *pr = str, *pw = str;
    while (*pr) {
        *pw = *pr++;
        pw += (*pw != c);
    }
    *pw = '\0';
}

/*******************************************************************************
* Function Name  : send_SOC_DATA
* Description    : Connect SERVER SOCKET and SEND DATA
* Input          : SERVER IP, SERVER PORT, DATA
* Output         : NONE
* Return         : 1- SENDED  0- FAILED
*******************************************************************************/
int send_SOC_DATA(char *ip,int soc , char *data ){

    char cmd[128];
    int len;
    
    sprintf(cmd,"AT+CIPSTART=\"TCP\",\"%s\",%d\r\n",ip,soc);
    printf("CMD:%s:\r\n",cmd);
    
    esp.sendCmd(cmd);
    memset(cmd,0,128);
    esp.readFromBuffer(cmd,DEFAULT_TIMEOUT,10);
  
    
    if( strncmp(cmd,"\r\nOK",4)!=0){
        
        if(strncmp(cmd,"ALREAY",6)!=0 )
            return 0;       
    }
        
    len=strlen(data);
    memset(cmd,0,128);
    sprintf(cmd,"AT+CIPSEND=%d\r\n",len);
    printf("CMD:%s:\r\n",cmd);
    
    esp.sendCmd(cmd);
    memset(cmd,0,128);
    esp.readFromBuffer(cmd,DEFAULT_TIMEOUT,1);
    
    if(strncmp(cmd,">",1)!=0)
        return 0;
    esp.sendCmd(data);
    
    memset(cmd,0,128);
    esp.readFromBuffer(cmd,DEFAULT_TIMEOUT,6);
    
    if(strncmp(cmd,"\r\nSEND OK",9)!=0)
        return 1;

    return 0;
}



/*******************************************************************************
* Function Name  : Echo_OFF
* Description    : MODEM ECHO OPTION OFF
* Input          : NONE
* Output         : NONE
* Return         : NONE
*******************************************************************************/

void Echo_OFF(void){
    
    esp.sendCmd("ATE0\r\n");   
    
    
} 
        
