/* ---------------------------------------------------------------------------
** This software is in the public domain, furnished "as is", without technical
** support, and with no warranty, express or implied, as to its usefulness for
** any purpose.
**
** esp8622.h
** NodeMCU serial comminication STM32F401RE Nucleo Board
** Author: <veyselka@hotmail.com> <v.karadag@gmail.com> Veysel KARADAG
** -------------------------------------------------------------------------*/



#ifndef __ESP8622_H__
#define __ESP8622_H__

#include "mbed.h"
#include "BufferedSerial.h"


#define DEFAULT_TIMEOUT     5





enum DataType {
    CMD     = 0,
    DATA    = 1,
};

/** Modem class.
 *  Used for Modem communication. attention that Modem module communicate with MCU in serial protocol
 */

class esp8622
{

    public:
    /** Create Modem Instance
     *  @param tx   uart transmit pin to communicate with Modem
     *  @param rx   uart receive pin to communicate with Modem
     *  @param baudRate baud rate of uart communication
     */
    esp8622(PinName tx, PinName rx, int baudRate) : esp8622_com(tx, rx) {
        esp8622_com.baud(baudRate);
    };
    
    BufferedSerial esp8622_com;

    /** send AT command to Modem module
     *  @param cmd  command array which will be send to GPRS module
     */
    void sendCmd(const char* cmd);

    /**send "AT" to Modem module
     */
    int sendATTest(void);
    
     /** check Modem module response before time out
     *  @param  *resp   correct response which Modem module will return
     *  @param  *timeout    waiting seconds till timeout
     *  @returns
     *      0 on success
     *      -1 on error
     */
    int readFromBuffer(char *resp, unsigned int timeout,unsigned int len);

    Timer timeCnt;


};


#endif
