/* ---------------------------------------------------------------------------
** This software is in the public domain, furnished "as is", without technical
** support, and with no warranty, express or implied, as to its usefulness for
** any purpose.
**
** esp8622.ccp
** NodeMCU serial comminication STM32F401RE Nucleo Board
** Author: <veyselka@hotmail.com> <v.karadag@gmail.com> Veysel KARADAG
** -------------------------------------------------------------------------*/

#include "esp8622.h"
#include "mbed.h"


char rx_buffer[255];

int esp8622::sendATTest(void)
{
    char resp[32];

    sendCmd("AT\r\n");
    memset(resp,0,32);
    readFromBuffer(resp,DEFAULT_TIMEOUT,10);
    
    if(strncmp(resp,"AT\r\r\n\r\nOK",9)==0)
        return 1;
    else
        return 0;
    

}

void esp8622::sendCmd(const char* cmd)
{
    esp8622_com.clear();
    esp8622_com.puts(cmd);
}


int esp8622::readFromBuffer(char *resp,unsigned int timeout,unsigned int len )
{
       
    timeCnt.start();
    int i=0;
   
    while(1) {
        
        if(esp8622_com.readable()) {
            char c = esp8622_com.getc();
            resp[i]=c;
            i++;
            if(i>=len)
                break;
        }
        
        if(timeCnt.read() > timeout) {
                break;
        }
    }
    timeCnt.stop();
    timeCnt.reset();
  //  printf("RESP:%s:\r\n",resp);
    return 0;
}
