#ifndef FBRDASH_MSCANHEADER_H
#define FBRDASH_MSCANHEADER_H

#define MSCAN_CMD   0   //a command to set a variable on the receiving processor to the value in the subsequent data part of the message, or
#define MSCAN_REQ   1   //a request for data, i.e., the value of a specific variable (and where to store the reply)
#define MSCAN_RSP   2   //a push-type message in reply to the destination processor's request for a variable value, the requested values are in the data buffer (&CAN_RB_DSR0) in the received message,
#define MSCAN_XSUB  3   //a message to this processor from device 1 to execute subroutine immediately here (set flag if can execute in main loop), or
#define MSCAN_BURN  4   //a message to burn RAM data table into flash data table.

#define MSCAN_ID_MS   0
#define MSCAN_ID_DASH 1

#define MSCAN_BLOCK_OUTPC   7

class MSCANHeader
{
    public:
        MSCANHeader();
        MSCANHeader(char to, char from, char type, char block, short offset);
        
        void parse(int id);
        int build();
        
        short var_offset;
        char msg_type;
        char from_id;
        char to_id;
        char var_blk;        
};

#endif