#include "MSCANHeader.h"

MSCANHeader::MSCANHeader()
{

}

MSCANHeader::MSCANHeader(char to, char from, char type, char block, short offset)
{
    to_id = to;
    from_id = from;
    msg_type = type;
    var_blk = block;
    var_offset = offset;
}

//MS encodes most of the request params in the message ID.
//Alignment is weird because the ID really includes some non-data bits. MS worked round these, mBed just skips them

//0-2   3 bits Spare on MSII
//3-6   4 bits Block to get data from. 7 = outpc, all the stuff that MS sends to the PC via serial
//7-10  4 bits To ID - 0 for MS
//11-14 4 bits From ID - Using 3 here for no good reason
//15-17 3 bits Message type. 1 to get data, response has 2
//18-28 11 bits Offset into the block in bits 3-6. Look in the INI file for Tuner Studio to find these, 
//              [OutputChannels] section starting line 3036

void MSCANHeader::parse(int id)
{
    var_offset = (id & 0x1FFC0000) >> 18;
    msg_type =   (id & 0x00038000) >> 15;
    from_id =    (id & 0x00007800) >> 11;
    to_id =      (id & 0x00000780) >> 7;
    var_blk =    (id & 0x00000078) >> 3;
}

int MSCANHeader::build()
{
    int id = 0;
    
    id |= (var_offset & 0x7FF)  << 18;
    id |= (msg_type & 0x7)      << 15;
    id |= (from_id & 0xF)       << 11;
    id |= (to_id & 0xF)         << 7;
    id |= (var_blk & 0xF)       << 3;
    
    return id;
}