#include "CANComms.h"
#include "mbed.h"
#include "State.h"

#include "MSCANHeader.h"

CANComms::CANComms(State* _values, bool transmit_poll, bool receive_poll, float poll_interval) : Comms(_values)
{


    can = new CAN(p30, p29);
    can->frequency(500000);

    pollTicker = new Ticker();
    readTicker = new Ticker();

    if(transmit_poll) {
        pollTicker->attach(this, &CANComms::poll, 0.05);
    }
    if (receive_poll) {
        can->attach(this, &CANComms::receive);
    }
}
void CANComms::poll()
{
    char i;

    //start 6, 22
    //int ids[] = {0x00189838, 0x00589838};

    short offsets[] = {6, 22};

    MSCANHeader header(MSCAN_ID_MS, MSCAN_ID_DASH, MSCAN_REQ, MSCAN_BLOCK_OUTPC, 0);

    for(i = 0; i < 2; i++) {
        header.var_offset = offsets[i];
        CANMessage msg(header.build(), 0, 3, CANData, CANExtended);

        msg.data[0] = i; //Where to put the response - used when communicating between MS's to tell them where they wanted the data put
        msg.data[1] = 0; //Offset into the table specified in data[0]
        msg.data[2] = 8; //How many bytes of the source table we want

        /*printf("Polling %d\n", i);*/

        if(can->write(msg)) {

        }
    }
}

void CANComms::send(char message)
{

}

void CANComms::receive()
{
    CANMessage msg;
    MSCANHeader header;

    while(can->read(msg)) {
        /*printf("CAN Message %08X %d %02X%02X%02X%02X%02X%02X%02X%02X\n", msg.id, msg.len,
            msg.data[0],
            msg.data[1],
            msg.data[2],
            msg.data[3],
            msg.data[4],
            msg.data[5],
            msg.data[6],
            msg.data[7]
            );*/

        header.parse(msg.id);

        //printf("Processing data, block %d\n", block);
        if(header.from_id == MSCAN_ID_MS) {
            if(header.var_blk == 0) {
                values->rpm = (msg.data[0] << 8) | msg.data[1];
            } else if(header.var_blk == 1) {
                values->manifold_pres = ((msg.data[2] << 8) | msg.data[3]) / 10.0;
                values->air_temp = (((msg.data[4] << 8) | msg.data[5]) - 320.0) * 0.05555;
                values->coolant_temp = (((msg.data[6] << 8) | msg.data[7]) - 320.0) * 0.05555;
            } else {
                values->throttle_pos = ((msg.data[2] << 8) | msg.data[3]) / 10.0;
                values->voltage = ((msg.data[4] << 8) | msg.data[5]) / 10.0;
            }
        }

        //printf("Bat: %f\n", battery / 10.0);
    }
}