//  ANALOG SENSORS
//  Logs information from all 6 analog inputs for 5 seconds in 100msec intervals (this is adjustable)
//  and writes the data to a "log.fbr" file on the SD card.

#define INTERVAL 0.100         //100 msec interval
#define NUM_OF_READINGS 50     //number of readings to be logged
#define MAX_VOLTAGE 3.3        //Readings are normalised to values between 0 and 1, need to multiply readings by 3.3V
#include "mbed.h"
#include "SDFileSystem.h"
#include <fstream>
#include <iomanip>

AnalogIn ain1(p15);   // SENSOR PINOUTS
AnalogIn ain2(p16);
AnalogIn ain3(p17);
AnalogIn ain4(p18);
AnalogIn ain5(p19);
AnalogIn ain6(p20);

DigitalOut led(LED1);   // LED PINOUT

SDFileSystem sd(p5, p6, p7, p8, "sd");   //SD CARD PINOUT

ofstream out;  // define output stream

int main() {

    out.open("/sd/log.fbr");
    out<<"START LOGGING\n";
    
    for(int n=1;n<=NUM_OF_READINGS;n++)
    {
    out<<setw(2)<<n
    <<setw(10)<<ain1*MAX_VOLTAGE
    <<setw(10)<<ain2*MAX_VOLTAGE
    <<setw(10)<<ain3*MAX_VOLTAGE
    <<setw(10)<<ain4*MAX_VOLTAGE
    <<setw(10)<<ain5*MAX_VOLTAGE
    <<setw(10)<<ain6*MAX_VOLTAGE
    <<endl;
    
    wait(INTERVAL);
    }
  
    out<<"END LOGGING\n";
    out.close();  // close output stream
    
    //////////////////////////////////////////////////////////////////////////////////////////
    led=1;
    wait(0.5);
    led=0;        // After the LED blinks, the program is done and the SD card may be removed.
    //////////////////////////////////////////////////////////////////////////////////////////
}