#ifndef TUIASI_PIXYLINKSPI_H
#define TUIASI_PIXYLINKSPI_H

#include "SPI.h"
#include "PixyLink.h"

class PixyLinkSPI : public PixyLink, private SPI
{
public:
    PixyLinkSPI(PinName mosi, PinName miso, PinName sclk) :
        SPI(mosi, miso, sclk), outLen(0), outIndex(0) {
    };
    
    virtual uint16_t getWord() {
        uint16_t w = ((uint16_t)getByte()) << 8;
        return w | getByte();
    };
    
    virtual uint8_t getByte() {
        uint8_t c = 0x00;
        if (outIndex < outLen) {
            c = outBuf[outIndex++];
        }
        return write(c);
    };

    virtual int8_t send(uint8_t *data, uint8_t len) {
        if (len > PIXY_OUTBUF_SIZE || outLen != 0)
            return -1;
        memcpy(outBuf, data, len);
        outLen = len;
        outIndex = 0;
        return len;
    };

private:
    static const uint8_t PIXY_OUTBUF_SIZE = 6;
    static const uint8_t PIXY_SYNC_BYTE = 0x5a;
    static const uint8_t PIXY_SYNC_BYTE_DATA = 0x5b;

    uint8_t outBuf[PIXY_OUTBUF_SIZE];
    uint8_t outLen;
    uint8_t outIndex;

};
#endif //TUIASI_PIXYLINKSPI_H