#include "mbed.h"
#include "CMPS03.h"

#define PERIOD 0.0001

CMPS03 boussole(p9,p10,CMPS03_DEFAULT_I2C_ADDRESS);

BusOut leds(LED1,LED2,LED3,LED4);

PwmOut MG(p21); //vitesse moteur gauche
PwmOut MD(p24); //vitesse moteur droit
DigitalOut sensMG(p23);  // sens moteur gauche
DigitalOut sensMD(p26);  // sens moteur droit

float vitesse(float vit)
{
    if(vit<0) vit=0;
    if(vit>60) vit=60;
    return ((vit/100.0)*PERIOD);
}



int main()
{

    sensMG.write(1);
    sensMD.write(1);
    MG.period(PERIOD);
    MD.period(PERIOD);
    MG.pulsewidth(vitesse(0));
    MD.pulsewidth(vitesse(0));
    
    while(1) {
        
        printf("CAP=%.1f \n\r",boussole.readBearing()/10.0);
        wait(0.1);
    }

}