/* 06_spi_max7219_led8x8
 *
 * Simple demo to drive a 8x8-as LED matrix by a MAX7219 LED driver IC
 * After initialisation two characters (H and W) are displayed alternatively.
 * The MAX7219 IC is driven by hardware SPI: SPI0 module at PTD1, PTD2, PTD3.
 */

#include "mbed.h"
#include "lib_matrix.h"

SPI spi(D11,D12,D13);          // Arduino compatible MOSI, MISO, SCLK
DigitalOut cs(D14);                // Chip select

int main()
{
    cs = 1;                         // CS initially High
    spi.format(8,0);                // 8-bit format, mode 0,0
    spi.frequency(1000000);         // SCLK = 1 MHz
    Init_MAX7219();                 // Initialize the LED controller
    char tab[20]="HELLOWO&&&";
    int i=0;
    while (1) {
        disp(tab[i]);
        i=(i+1)%10;
        wait(0.5);
        disp(' ');
        wait(0.1);        // 1 sec delay

    }
}

void disp(char c)
{
    switch(c) {
        case 'E' :
            for(int i=1; i<9; i++)      // Write first character (8 rows)
                SPI_Write2(i,led_E[i-1]);
            break;
        case 'H' :
            for(int i=1; i<9; i++)      // Write first character (8 rows)
                SPI_Write2(i,led_H[i-1]);
            break;
        case 'L' :
            for(int i=1; i<9; i++)      // Write first character (8 rows)
                SPI_Write2(i,led_L[i-1]);
            break;
        case 'O' :
            for(int i=1; i<9; i++)      // Write first character (8 rows)
                SPI_Write2(i,led_O[i-1]);
            break;
        case 'W' :                   // 1 sec delay
            for(int i=1; i<9; i++)      // Write second character
                SPI_Write2(i,led_W[i-1]);
            break;
        case ' ' :                   // 1 sec delay
            for(int i=1; i<9; i++)      // Write second character
                SPI_Write2(i,led_blank[i-1]);
            break;
        case '&' :                   // 1 sec delay
            for(int i=1; i<9; i++)      // Write second character
                SPI_Write2(i,led_heart[i-1]);
            break;
    }
}
/// Send two bytes to SPI bus
void SPI_Write2(unsigned char MSB, unsigned char LSB)
{
    cs = 0;                         // Set CS Low
    spi.write(MSB);                 // Send two bytes
    spi.write(LSB);
    cs = 1;                         // Set CS High
}

/// MAX7219 initialisation
void Init_MAX7219(void)
{
    SPI_Write2(0x09, 0x00);         // Decoding off
    SPI_Write2(0x0A, 0x08);         // Brightness to intermediate
    SPI_Write2(0x0B, 0x07);         // Scan limit = 7
    SPI_Write2(0x0C, 0x01);         // Normal operation mode
    SPI_Write2(0x0F, 0x0F);         // Enable display test
    wait_ms(500);                   // 500 ms delay
    SPI_Write2(0x01, 0x00);         // Clear row 0.
    SPI_Write2(0x02, 0x00);         // Clear row 1.
    SPI_Write2(0x03, 0x00);         // Clear row 2.
    SPI_Write2(0x04, 0x00);         // Clear row 3.
    SPI_Write2(0x05, 0x00);         // Clear row 4.
    SPI_Write2(0x06, 0x00);         // Clear row 5.
    SPI_Write2(0x07, 0x00);         // Clear row 6.
    SPI_Write2(0x08, 0x00);         // Clear row 7.
    SPI_Write2(0x0F, 0x00);         // Disable display test
    wait_ms(500);                   // 500 ms delay
}
