#include "mbed.h"
BusOut affi(D2,D3,D4,D5,D6,D7,D8,D9); //D2=segment a / D3= segment b / ... / D9 = Dot Point
int conv(int); //prototype de la fonction de conversion

Timer chrono; //Timer permettant de mesurer le temps écoulé
DigitalIn BP1(D12),BP2(A5) ; // Boutons poussoirs

int main()  // Programme principal
{
    int b1av;       // Variable stockant l'état précédent de BP1
    int b1=1;       // Variable stockant l'état actuel de BP1
    int b2;         // Variable stockant l'état actuel de BP2
    int etattimer=0;// Flag pour stocker l'état du timer arrêté=0 ou lancé=1
    int diz,uni,dix;// Variable pour l'affichage en boucle : dizaines, unités, dixièmes

    BP1.mode(PullUp) ; // BP1 et BP2 en mode PullUp
    BP2.mode(PullUp) ;
    float temps;        // Variable réelle pour stocker la valeur du Timer  
    chrono.stop();      // Arrêt du Timer
    chrono.reset();     // Remise à zéro du Timer
    
    while(1) {          // Boucle infinie
    
        b1av=b1 ;       // Mémorisation de l'ancienne valeur de BP1
        b1=BP1.read() ; // Lecture de la nouvelle valeur de BP1
        b2=BP2.read() ; // Lecture de BP2
        
        if(b1av==1 && b1==0) {  // Si front descendant sur BP1
            if(etattimer==0) {  // Si le Timer est à l'arrêt
                chrono.start() ;// On démarre le Timer
                etattimer =1;   // On met le Flag à 1 = Timer lancé
            } else {            // Sinon
                chrono.stop() ; // On arrête le Timer
                etattimer=0;    // On met le Flag à 0 = Timer arrêté
            }
        }
        
        if(b2==0) {
            chrono.reset() ;//Si b2 enfoncé => RAZ du Timer
        }
        
        temps=chrono.read();      //On lit le Timer
        
        if(etattimer==1) {              //Si le Timer est lancé
            if(temps<1) affi.write(conv((int)(temps*10))); //Affichage des dixièmes si temps < 1 seconde
            else {
                if(temps<10) affi.write(conv((int)temps)); //Affichage des unités si 1 < temps < 10 secondes
                else         affi.write(conv((int)temps/10));//Affichage des unités si temps > 10 secondes
            }
                } else {                   // Sinon = le Timer est arrêté
            diz=(int)(temps/10);                // Calcul des dizaines 
            uni=((int)(temps))%10;              // Calcul des unités
            dix=(int)((temps-uni-(10*diz))*10); // Calcul des dixièmes
            printf("temps=%.1f %d %d . %d \n\r",temps,diz,uni,dix);
            affi.write(conv(255));          // Eteindre l'afficheur 0,5s
            wait(0.5);
            affi.write(conv(diz));          // Afficher les dizaines 0,3s
            wait(0.3);
            affi.write(conv(uni));          // Afficher les unités 0,3s
            wait(0.3);
            affi.write(conv(16));           // Afficher le point 0,3s
            wait(0.3);
            affi.write(conv(dix));          // Afficher les dixièmes 0,3s
            wait(0.3);
        }
    }
}
int conv(int e)         // Corps de la fonction de conversion   
{
    int s;
    switch(e) {
        case 0:
            s=0b11000000;//ou 192 ou 0xC0 -- Affiche un Zéro
            break;
        case 1:
            s=0b11111001;//ou 249 ou 0xF9 -- Affiche un 1
            break;
        case 2:
            s=0b10100100;
            break;
        case 3:
            s=0b10110000;
            break;
        case 4:
            s=0b10011001;
            break;
        case 5:
            s=0b10010010;
            break;
        case 6:
            s=0b10000010;
            break;
        case 7:
            s=0b11111000;
            break;
        case 8:
            s=0b10000000;
            break;
        case 9:
            s=0b10010000;
            break;
        case 16:
            s=0b01111111;   // Affiche le point (Dot Point)
            break;
        default :           // Eteint l'afficheur
            s=255;
    }
    return s;
}
