#include "mbed.h"
#include "USBSerial.h"
#include "millis.h"


DigitalOut  myLed(LED1);
DigitalIn   digitalOutputPIR(PTB0);
USBSerial   serial;


int MeasureTriggerDelay(void) {
    
    uint8_t measureFlagON = 0;
    uint8_t completeMeasureFlag = 0;
    time_t triggerTime, offTime;
    
    while(!completeMeasureFlag){
    
        if(digitalOutputPIR) {
        
            myLed = 0;
            if(!measureFlagON) {
            
                triggerTime = millis() / 1000;
                serial.printf("/KALIBRACE/ Detekovan pohyb /KALIBRACE/\r\n");
            
            }
            measureFlagON = 1;
               
        }
        else {
            
            myLed = 1;
            offTime = millis() / 1000;
            serial.printf("/KALIBRACE/ Vystup odpojen, trigger delay je %d sekund /KALIBRACE/\r\n", offTime - triggerTime);
            if(measureFlagON) completeMeasureFlag = 1;
             
       }         

    }
    
    return (offTime - triggerTime);
}


int main() {

    int triggerDelayTime = 3; //vychozi nastaveni 3 sekundy
    uint8_t repeatTriggerCount = 0;
    int printFlag = 0;
    int triggerTime = 0;
    myLed = 1;
      
    millisStart();
    wait(6);
    
    serial.printf("Zjistuji dobu aktivniho vystupu - trigger delay\r\n");
    while(digitalOutputPIR != 1) {};
    triggerDelayTime = MeasureTriggerDelay();
    
    while(1) {
        
        if(digitalOutputPIR)
        {
            myLed = 0;
            if(!printFlag) {
                
                triggerTime = millis()/1000;  
                serial.printf("Detekovan pohyb %d sekund od zapnuti FRDM\r\n", triggerTime);
                printFlag = 1;
                   
            }
        }
        else { 
            
            int offTime = millis() / 1000;
            if(printFlag) {
                
                repeatTriggerCount = ((offTime - triggerTime) / triggerDelayTime) - 1;
                if(((offTime - triggerTime) / triggerDelayTime - 1) < 0) repeatTriggerCount = 0;
        
                serial.printf("LED vypnuta po %d sekundach od sepnuti\r\n", offTime - triggerTime);
                serial.printf("Opakovany trigger probehl %dx krat\r\n", repeatTriggerCount);
                      
            }
            myLed = 1;
            printFlag = 0;
            
        }
    }
}

