#include "mbed.h"
#include "USBSerial.h"

DigitalOut  myLed(LED1);
DigitalIn   digitalOutputPIR(PTB0);
AnalogIn    analogOutputPIR(A1);
USBSerial   serial;

int main() {
    
    float analogValue = 0;
       
    while(1) {
          
        analogValue = float(analogOutputPIR);
        myLed = !digitalOutputPIR;
        
        serial.printf("%f", 255*analogValue); //posli analogovou hodnotu na UART
        serial.printf(" ");
        
        if(digitalOutputPIR) serial.printf("50\r\n"); //posli hodnotu logickeho vystupu na UART (50 = log. 1, scaling osy Y)
        else serial.printf("0\r\n");
        wait_ms(10);
        
    }
}

