/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name:Yuhan Yang
Username:el18yy
Student ID Number:200981726
Date:08-05-2019
*/

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Board.h"
#include "map.h"

N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
Board board;
map m;
//Engine engine;

void init();
void render();
void welcome();

int main()
{

    int fps = 8;  

    init();    
    welcome(); 
    render(); 
    wait(1.0f/fps); 
    m.maps(lcd,pad);



    while (1) {
        board.read_input(pad);
        board.update();
        board.ball(lcd);
        board.nextpos(lcd);
        render();
        
        wait(1.0f/fps);
    }
}


void render()
{
    // clear screen, re-draw and refresh
    lcd.clear();  
    board.draw(lcd);
    lcd.refresh();
}

// simple splash screen displayed on start-up
void welcome() {
    
    lcd.printString(" Clear bricks! ",0,1);  
    lcd.printString("  Press Start ",0,4);
    lcd.refresh();
     
    // wait flashing LEDs until start button is pressed 
    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.2);
        pad.leds_off();
        wait(0.2);
    }
 
}

void init()
{
    // need to initialise LCD and Gamepad 
    lcd.init();
    pad.init();
    board.init();

}