#ifndef BOARD_H
#define BOARD_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Board Class
@brief Class for main engine for the snake game
@author Yuhan Yang
@date 8th May 2019
*/
/** ball struct */
struct Target{
    char _xx[40];
    char _yy[40];
    
};

/** ball struct */
struct Ball{
    char _a;
    char _b;
    char _dir;
    
};

/** Board Class
* @brief Class for the main game engine and the movement of ball and board.
* @author Yuhan Yang
* @date May, 2019
*/

class Board
{
public:
    /** Constructor */
    Board();
    /** Destructor */
    ~Board();
     /** 
    * @brief get the direction of gamepad.
    * @param N5110 *lcd @details pointer to the N5110 object in main, address of this pointer is saved to make availability to the entire class, without passing address to each function.
    */
    void read_input(Gamepad &pad);
    /** 
    * @brief initial all the parameter for board and ball.
    */
    void init();
     /** 
    * @brief print ball, board and bricks on the screen.
    * @param N5110 *lcd @details pointer to the N5110 object in main, address of this pointer is saved to make availability to the entire class, without passing address to each function.
    */
    void draw(N5110 &lcd);
     /** 
    * @brief control the board to the left or right.
    * @param N5110 *lcd @details pointer to the N5110 object in main, address of this pointer is saved to make availability to the entire class, without passing address to each function.
    */
    void update();
     /** 
    * @brief Print Current position of the ball.
    * @param N5110 *lcd @details pointer to the N5110 object in main, address of this pointer is saved to make availability to the entire class, without passing address to each function.
    */
    void ball(N5110 &lcd);
     /** 
    * @brief the movement of the ball when the ball hit each brick or board.
    * @param N5110 *lcd @details pointer to the N5110 object in main, address of this pointer is saved to make availability to the entire class, without passing address to each function.
    */
    void nextpos(N5110 &lcd);
   /** 
    * @brief check ball missed the board.
    * @param N5110 *lcd @details pointer to the N5110 object in main, address of this pointer is saved to make availability to the entire class, without passing address to each function.
    * @param Gamepad *pad @details pointer to the gamepad object in main, address of this pointer is saved to make availability to the entire class, without passing address to each function.
    */
    void die();


private:

    Direction _d;
    float _mag;
    int _x;
    int _y;
    int _speed;
    int _direction;

};
#endif