#include "mbed.h"
#include "HIDScope.h"
#include "QEI.h"
#include "iostream"
#include "MODSERIAL.h"

//Leds
DigitalOut ledb(LED_BLUE);
DigitalOut ledr(LED_RED);
DigitalOut ledg(LED_GREEN);

//Motor
DigitalOut motor1DC(D7);
PwmOut motor1PWM(D6);

//Button
DigitalIn   button1(SW2);

// HIDscope
HIDScope scope(1);

//Ticker
Ticker tick;
float f = 0.2;

// Encoder
float X = 32.0;
float N = 131.0;
float pulse_count;
float angle_motor;
QEI Encoder(D8,D9,NC,N);
MODSERIAL pc(USBTX,USBRX);

//ticker function

//void send(angle)
//{ 

//    scope.set(0, angle);
//    scope.send();
//}


int main()
{

    pc.baud(9600);
    pc.printf("Hello world");
    motor1DC = -1;
    ledb = 1;
    ledr = 1;
    ledg = 0;

    while (true) {

        //angle=0;

        if(button1==false) {
            
            
            
            wait(1.0); // wait before next roll to protect motors
            //ledr = 1;
            ledb = 1;
            //ledg = 0; // green led on = ready to roll

            ledg = 1; // green led off
            ledr = 0; // red led on = rolling

            motor1PWM = 1; // motor on
            wait(3.00); //1.025
            motor1PWM = 0; // motor off

            wait(1.0);
            ledr = 1;
            ledb = 1;
            ledg = 0;
            // green led on = ready to roll

            // Get pulses and send to HIDScope
            pulse_count = Encoder.getPulses();

            float angle_pp =360/(X * N);
            float angle = pulse_count*angle_pp;

            pc.printf(" pulse count: %f angle: %f \r \n ", pulse_count, angle);
            
            //tick.attach(&send(angle), f);

            scope.set(0, angle);
            scope.send();

            Encoder.reset();
            
            
        }

    }



}

// screen /dev/tty.usbmodem1412 9600