#include "mbed.h"
#include "HIDScope.h"
#include "QEI.h"
#include "iostream"

//Leds
DigitalOut ledb(LED_BLUE);
DigitalOut ledr(LED_RED);
DigitalOut ledg(LED_GREEN);

//Motor
DigitalOut motor1DC(D7);
PwmOut motor1PWM(D6);

//Button
DigitalIn   button1(SW2);

// HIDscope
HIDScope scope(1);

// Encoder
//Ticker tick;
float F = 0.02;
float X = 32;
float N = 131;
float pulse_count;
float angle_motor;
QEI Encoder(A0,A1,NC,N);

//Minimum wait time between rolls
float t = 1.5;

// Encoder measurement function
void Measure()
{
    // Get pulses and send to HIDScope
    pulse_count = Encoder.getPulses();
    
    int angle_pp =360/(X * N);
    
   int angle = pulse_count*angle_pp;
    
    scope.set(0, angle);
    scope.send();
}

//Dice rolling function
void Roll()
{  
    ledg = 1; // green led off
    ledr = 0; // red led on = rolling
    
    motor1PWM = 1; // motor on -> roll dice
    wait(3);
    motor1PWM = 0; // motor off

    //motor1DC = abs(motor1DC-1); // rotate other way next time
    
    //ledr = 1; // red led off
    //ledb = 0; // blue led on
    
    //Encoder.reset();
}

int main()
{
    motor1DC = 1;
    ledb = 1;
    ledr = 1;
    ledg = 0;
    
    while (true) 
    {
        if(button1==0)
        { 
            Roll();
            wait(t); // wait before next roll to protect motors
            ledb = 1;
            ledg = 0; // green led on = ready to roll
        } 
        Measure();     
    }
}