#include "TouchPanel.h"

#define DEBUG_TOUCH_CALIBRATED    //chestia asta ar trebui sa afiseze punctele de calibrare a touchului pe seriala

Matrix matrix ;
Coordinate  display ;
Coordinate ScreenSample[3];
Coordinate DisplaySample[3] = {{30,  45},
                               {250, 70},
                               {160,210}};
                               
extern Serial debug;                               

Touch::Touch(SSD1289_LCD *lcd,SPI *spi, DigitalOut *cs, DigitalIn *irq)
{
    _cs=cs;
    *_cs=1;
    _spi=spi;
    _irq=irq;
    _lcd=lcd;
}

void Touch::InitializeTouch()
{
    _spi->format(8,0);
    _spi->frequency(100000);
    *_cs = 1;
}

int Touch::RDAD(void)
{
    unsigned short buf,temp;
    
    temp=_spi->write(0);
    buf=temp<<8;
    temp=_spi->write(0);
    buf|=temp;
    buf>>=3;
    buf&=0xFFF;
    return buf;
}

int Touch::ReadX(void)
{
    int i;
    *_cs=0;
    wait(0.000001);
    _spi->write(CHX);
    wait(0.000001);
    i=RDAD();
    *_cs=1;
    return i;
}

int Touch::ReadY(void)
{
    int i;
    *_cs=0;
    wait(0.000001);
    _spi->write(CHY);
    wait(0.000001);
    i=RDAD();
    *_cs=1;
    return i;
}

void Touch::GetAdXY(int *x,int *y)
{
    int adx,ady;
    adx=ReadX();
    wait(0.000001);
    ady=ReadY();
    *x=adx;
    *y=ady;
}

void Touch::DrawPoint(int Xpos,int Ypos)
{
    _lcd->DrawPixel(Xpos,Ypos,COLOR_BLUE);     
    _lcd->DrawPixel(Xpos+1,Ypos,COLOR_BLUE);
    _lcd->DrawPixel(Xpos,Ypos+1,COLOR_BLUE);
    _lcd->DrawPixel(Xpos+1,Ypos+1,COLOR_BLUE); 
}   

void Touch::DrawCross(int Xpos,int Ypos)
{
    _lcd->DrawLine(Xpos-15,Ypos,Xpos-2,Ypos,COLOR_WHITE);
    _lcd->DrawLine(Xpos+2,Ypos,Xpos+15,Ypos,COLOR_WHITE);
    _lcd->DrawLine(Xpos,Ypos-15,Xpos,Ypos-2,COLOR_WHITE);
    _lcd->DrawLine(Xpos,Ypos+2,Xpos,Ypos+15,COLOR_WHITE);
    
    _lcd->DrawLine(Xpos-15,Ypos+15,Xpos-7,Ypos+15,RGB(184,158,131));
    _lcd->DrawLine(Xpos-15,Ypos+7,Xpos-15,Ypos+15,RGB(184,158,131));
    
    _lcd->DrawLine(Xpos-15,Ypos-15,Xpos-7,Ypos-15,RGB(184,158,131));
    _lcd->DrawLine(Xpos-15,Ypos-7,Xpos-15,Ypos-15,RGB(184,158,131));
    
    _lcd->DrawLine(Xpos+7,Ypos+15,Xpos+15,Ypos+15,RGB(184,158,131));
    _lcd->DrawLine(Xpos+15,Ypos+7,Xpos+15,Ypos+15,RGB(184,158,131));
    
    _lcd->DrawLine(Xpos+7,Ypos-15,Xpos+15,Ypos-15,RGB(184,158,131));
    _lcd->DrawLine(Xpos+15,Ypos-15,Xpos+15,Ypos-7,RGB(184,158,131));      
}   

Coordinate *Touch::ReadAds7846(void)
{
    static Coordinate  screen;
    int m0,m1,m2,TP_X[1],TP_Y[1],temp[3];
    uint8_t count=0;
    int buffer[2][9]={{0},{0}};
    
    do
    {        
        GetAdXY(TP_X,TP_Y);  
        buffer[0][count]=TP_X[0];  
        buffer[1][count]=TP_Y[0];
        count++;  
    }
    
    while((!_irq->read()) && count<9)
        ;
        
    if(count==9)   
    {
        temp[0]=(buffer[0][0]+buffer[0][1]+buffer[0][2])/3;
        temp[1]=(buffer[0][3]+buffer[0][4]+buffer[0][5])/3;
        temp[2]=(buffer[0][6]+buffer[0][7]+buffer[0][8])/3;
        
        m0=temp[0]-temp[1];
        m1=temp[1]-temp[2];
        m2=temp[2]-temp[0];
        
        m0=m0>0?m0:(-m0);
        m1=m1>0?m1:(-m1);
        m2=m2>0?m2:(-m2);
        
        if( m0>THRESHOLD  &&  m1>THRESHOLD  &&  m2>THRESHOLD ) 
            return 0;
        
        if(m0<m1)
        {
            if(m2<m0) 
                screen.x=(temp[0]+temp[2])/2;
            else 
                screen.x=(temp[0]+temp[1])/2;   
        }
        else if(m2<m1) 
            screen.x=(temp[0]+temp[2])/2;
        else 
            screen.x=(temp[1]+temp[2])/2;
        
        temp[0]=(buffer[1][0]+buffer[1][1]+buffer[1][2])/3;
        temp[1]=(buffer[1][3]+buffer[1][4]+buffer[1][5])/3;
        temp[2]=(buffer[1][6]+buffer[1][7]+buffer[1][8])/3;
        
        m0=temp[0]-temp[1];
        m1=temp[1]-temp[2];
        m2=temp[2]-temp[0];
        
        m0=m0>0?m0:(-m0);
        m1=m1>0?m1:(-m1);
        m2=m2>0?m2:(-m2);
        
        if(m0>THRESHOLD&&m1>THRESHOLD&&m2>THRESHOLD) 
            return 0;
        
        if(m0<m1)
        {
            if(m2<m0) 
                screen.y=(temp[0]+temp[2])/2;
            else 
                screen.y=(temp[0]+temp[1])/2;   
        }
        else if(m2<m1) 
            screen.y=(temp[0]+temp[2])/2;
        else
            screen.y=(temp[1]+temp[2])/2;
        
        return &screen;
    }  
    return 0; 
}

bool Touch::setCalibrationMatrix( Coordinate * displayPtr, Coordinate * screenPtr, Matrix * matrixPtr)
{
    bool retTHRESHOLD = true ;

    matrixPtr->Divider = ((screenPtr[0].x - screenPtr[2].x) * (screenPtr[1].y - screenPtr[2].y)) - ((screenPtr[1].x - screenPtr[2].x) * (screenPtr[0].y - screenPtr[2].y)) ;
    if( matrixPtr->Divider == 0 )
    {
        retTHRESHOLD = false;
    }
    else
    {
        matrixPtr->An = ((displayPtr[0].x - displayPtr[2].x) * (screenPtr[1].y - screenPtr[2].y)) - ((displayPtr[1].x - displayPtr[2].x) * (screenPtr[0].y - screenPtr[2].y)) ;
        matrixPtr->Bn = ((screenPtr[0].x - screenPtr[2].x) * (displayPtr[1].x - displayPtr[2].x)) - ((displayPtr[0].x - displayPtr[2].x) * (screenPtr[1].x - screenPtr[2].x)) ;
        matrixPtr->Cn = (screenPtr[2].x * displayPtr[1].x - screenPtr[1].x * displayPtr[2].x) * screenPtr[0].y + (screenPtr[0].x * displayPtr[2].x - screenPtr[2].x * displayPtr[0].x) * screenPtr[1].y + (screenPtr[1].x * displayPtr[0].x - screenPtr[0].x * displayPtr[1].x) * screenPtr[2].y ;
        matrixPtr->Dn = ((displayPtr[0].y - displayPtr[2].y) * (screenPtr[1].y - screenPtr[2].y)) - ((displayPtr[1].y - displayPtr[2].y) * (screenPtr[0].y - screenPtr[2].y)) ;
        matrixPtr->En = ((screenPtr[0].x - screenPtr[2].x) * (displayPtr[1].y - displayPtr[2].y)) - ((displayPtr[0].y - displayPtr[2].y) * (screenPtr[1].x - screenPtr[2].x)) ;
        matrixPtr->Fn = (screenPtr[2].x * displayPtr[1].y - screenPtr[1].x * displayPtr[2].y) * screenPtr[0].y + (screenPtr[0].x * displayPtr[2].y - screenPtr[2].x * displayPtr[0].y) * screenPtr[1].y + (screenPtr[1].x * displayPtr[0].y - screenPtr[0].x * displayPtr[1].y) * screenPtr[2].y ;
    }
    return( retTHRESHOLD ) ;
}

bool Touch::getDisplayPoint(Coordinate * displayPtr,Coordinate * screenPtr,Matrix * matrixPtr )
{
    bool retTHRESHOLD =true ;
    
    if( matrixPtr->Divider != 0 )
    {   
        displayPtr->x = ( (matrixPtr->An * screenPtr->x) + (matrixPtr->Bn * screenPtr->y) + matrixPtr->Cn ) / matrixPtr->Divider ;  
        displayPtr->y = ( (matrixPtr->Dn * screenPtr->x) + (matrixPtr->En * screenPtr->y) + matrixPtr->Fn ) / matrixPtr->Divider ;
    }
    else
    {
        retTHRESHOLD = false;
    }
    
    return(retTHRESHOLD);
} 


void Touch::TouchPanelCalibrate(void)
{
    uint8_t i;
    Coordinate * Ptr;
    
    for(i=0;i<3;i++)
    {
        _lcd->ClearScreen();
        _lcd->SetFont( &Font8x16 );
        _lcd->Print("Calibrare Touch-Screen",CENTER,10,COLOR_WHITE,COLOR_BLACK,0);
        wait(0.3);
        DrawCross(DisplaySample[i].x,DisplaySample[i].y);
        do
        {
            Ptr=ReadAds7846();            
        }
        while( Ptr == (void*)0 );
        ScreenSample[i].x= Ptr->x; 
        ScreenSample[i].y= Ptr->y;
        #ifdef DEBUG_TOUCH_CALIBRATED
        debug.printf("Touch-Point: x=[%d] | y=[%d]\r\n",Ptr->x,Ptr->y);
        #endif
    }
    setCalibrationMatrix( &DisplaySample[0],&ScreenSample[0],&matrix );
} 

void Touch::TouchPanelExperimentalCalibrate(int *values)
{
    int i;
    
    for (i=0;i<3;i++)
    {
        ScreenSample[i].x = values[i*2];
        ScreenSample[i].y = values[i*2+1];
    }
    setCalibrationMatrix( &DisplaySample[0],&ScreenSample[0],&matrix );
}
