#ifndef __TOUCH_PANEL__
#define __TOUCH_PANEL__

#include "mbed.h"
#include "ssd1289.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct POINT 
{
   uint16_t x;
   uint16_t y;
}Coordinate;

typedef struct Matrix 
{                       
    long double An,Bn,Cn,Dn,En,Fn,Divider;
} Matrix ;

extern Coordinate ScreenSample[3];
extern Coordinate DisplaySample[3];
extern Matrix matrix ;
extern Coordinate  display ;

#define CHX     144
#define CHY     208

#define THRESHOLD 2

class Touch
{
    public:
        Touch(SSD1289_LCD *lcd,SPI *spi, DigitalOut *cs, DigitalIn *irq);
        void InitializeTouch();
        Coordinate *ReadAds7846(void);
        void TouchPanelCalibrate(void);
        void TouchPanelExperimentalCalibrate(int *values);    //values must be in order (x y) topleft, (x y) topright, (x y) midbottom
        bool getDisplayPoint(Coordinate * displayPtr,Coordinate * screenPtr,Matrix * matrixPtr );
        
    protected:
        int RDAD(void);
        int ReadX(void);
        int ReadY(void);
        void GetAdXY(int *x,int *y);
        void DrawPoint(int Xpos,int Ypos);
        void DrawCross(int Xpos,int Ypos);
        bool setCalibrationMatrix( Coordinate * displayPtr, Coordinate * screenPtr, Matrix * matrixPtr);    
            
    private:
        SPI *_spi;
        DigitalOut *_cs;
        DigitalIn *_irq;
        SSD1289_LCD *_lcd;
};


#ifdef __cplusplus
}
#endif


#endif