#include "mbed.h"
#include "SimpleBLE.h"

DigitalOut led(LED1);

// The first thing we need to do is create a SimpleBLE instance:
// * first argument is the device name
// * second is the advertisement interval in ms. (default 1000 ms.)
SimpleBLE ble("DEVICE_NAME");

// Now we can declare some variables that we want to expose.
// After you created the variable you can use it like any other var,
// but it's value will be automatically updated over Bluetooth!

// F.e. here we declare service 0x180d (heartrate), char 0x2a37 (curr. value) as uint8_t
SimpleChar<uint8_t> heartrate = ble.readOnly_u8(0x180D, 0x2A37, true /* notify */, 100 /* default value */);

// now we can use this variable everywhere in our code like a normal uint8_t
void updateHeartrate() {
      led = !led; // keep-alive LED
    // we just loop between 100 and 180
    heartrate = heartrate + 1;
    if (heartrate > 180) {
        heartrate = 100;
    }
}

// And here we create a custom service (0x9310) and char (0x9311) with a callback
void callback(uint32_t newValue) {
    // whenever someone updates this var over Bluetooth, this function will be called
    printf("My value was updated to %d\n", newValue);
}
// FYI, you can also use long UUID strings here instead of short services :-)
SimpleChar<uint32_t> writeMe = ble.readWrite_u32(0x9310, 0x9311, &callback);

int main(int, char**) {
    // update the heart rate every second
    Ticker t;
    t.attach(updateHeartrate, 1.0f);
    
    // here's how we kick off our loop
    ble.start();
    while (1) {
        ble.waitForEvent();
    }

}