#include "mbed.h"
#include "uLCD_4DGL.h"
#include "Servo.h"
#include "Motor.h"

PwmOut myled(p23);
Servo myservo(p22);
uLCD_4DGL uLCD(p9,p10,p11); // serial tx, serial rx, reset pin;
Motor m(p21, p14, p13); // pwm, fwd, rev
RawSerial  dev(p13,p14);

int main() {
    
    myled.period(0.01f);
    uLCD.baudrate(300000);
    uLCD.cls();
    while(1) {
        myled.write(0.3f);
//        wait(2);
        m.speed(0.5f);
        myled.write(0.6f);
//        wait(2);
        myservo = 1.0f;
        myled.write(0.9f);
//        wait(2);
        
        uLCD.locate(0,0);
        uLCD.printf("%s",dev.getc());
        wait(0.3);
        
    }
}
