#include "mbed.h"
#include "ultrasonic.h"

Serial pc(USBTX, USBRX);
DigitalOut start(p30,1);
DigitalOut right(p29,1);
DigitalOut left(p28,1);
DigitalOut up(p27,1);
DigitalOut down(p26,1);
DigitalOut on_switch(p25,0);
DigitalOut myled(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
InterruptIn car_start(p23);


//int volatile start_var = 0;
//int volatile counter = 1;
//int volatile drive_var = 0;
//int volatile movement = 0;
int volatile right_var = 0;
int volatile left_var = 0;

void drive_func(); 

void dist(int distance) //necessary for the sonar to work. I dont know why.
{
    
}

ultrasonic front(p6, p7, .1, 1, &dist);    //Set the trigger pin to D8 and the echo pin to D9
ultrasonic rightc(p8,p9,.1,1, &dist); 
ultrasonic leftc(p21,p22,.1,1, &dist);                                    //have updates every .1 seconds and a timeout after 1
ultrasonic back(p13,p14,0.1,1, &dist);  

void starting_commands(){ // toggles the button to start the cop car
    start = 0;
    wait(0.1);
    start = 1;
    wait(0.1);
    }


void start_func() // sequence that gets the cop car into no noise run mode
{
    on_switch =1;
    starting_commands();
    starting_commands();
    starting_commands();
    starting_commands();
    starting_commands();
}

void drive_func() // pulses the drive pin; the pulsing is so that the car doesnt go too fast
{
    front.checkDistance();     
    while(front.getCurrentDistance() > 300){
        front.checkDistance();
        up = 0;
        wait(0.1);
        up = 1;
        wait(0.1);
        }
}

void stop_func() // stops the car and checks right and left sonars for obstructions
{
    up = 1;
    down = 0;
    wait(0.1);
    down = 1;
    front.checkDistance();     
    rightc.checkDistance();
    leftc.checkDistance();
    back.checkDistance();
    if (rightc.getCurrentDistance()<300) right_var = 1;
    if (leftc.getCurrentDistance()<300) left_var = 1;
}
        
void turn_func() // turns the car until the front sonar is unobstructed
{
    int turn_var = 0;
    while(turn_var == 0){
        if (right_var == 0){
            down = 0;
            wait(0.1);
            down = 1;
            right=up=0;
            wait(0.1);
            right=up=1;
            if(front.getCurrentDistance()>300) turn_var = 1;
        }
        else if (left_var == 0){
            down = 0;
            wait(0.1);
            down = 1;
            left=up=0;
            wait(0.1);
            left=up=1;
            if(front.getCurrentDistance()>300) turn_var = 1;
        }
        else {
            down = 0;
            wait(0.2);
            down = 1;
            if (rightc.getCurrentDistance()>300) right_var = 0;
            if (leftc.getCurrentDistance()>300) left_var = 0;
        }
    }
    left_var = right_var = 0;
}

int main() {
    wait(3);
    
    front.startUpdates();
    rightc.startUpdates();
    leftc.startUpdates();
    back.startUpdates();
    start_func();
    //int front_var = 0;
//    int rear_var = 0;
//    int right_var = 0;
//    int left_var = 0;
//    
    
    while(1) {
        front.checkDistance();     //call checkDistance() as much as possible, as this is where
        rightc.checkDistance();
        leftc.checkDistance();
        back.checkDistance();
        pc.printf("Front Distance %d mm\r\n", front.getCurrentDistance());
        pc.printf("Right Distance %d mm\r\n", rightc.getCurrentDistance());
        pc.printf("Left Distance %d mm\r\n", leftc.getCurrentDistance());
        pc.printf("Back Distance %d mm\r\n", back.getCurrentDistance());
        
        drive_func();
        stop_func();
        turn_func();
       
    }
}
