#include "mbed.h"
#include "NTPClient.h"
#include "uLCD_4DGL.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"
#include "Servo.h"
#include "Motor.h"



Serial blue(p13,p14);
PwmOut ledRGB(p23);
Servo myservo(p22);
Motor m(p21, p17, p16); // pwm, fwd, rev
//InterruptIn button(p28);

//SET UP ETHERNET & ULCD
EthernetInterface eth;
uLCD_4DGL uLCD(p9,p10,p11); // serial tx, serial rx, reset pin;
NTPClient ntpClient;
HTTPClient httpClient;
void parse(char buffer[], int *j, char *string); //FUNCTION TO PARSE HTTP GET DATA
char httpGetData[200]; //BUFFER TO HOLD DATA FROM HTTP GET REQUEST

BusOut myled(LED1,LED2,LED3,LED4);


//
//void flip(){
//    setTime = 1+setTime;
//    if (setTime > 24) {
//        setTime = 00;
//        }
//    } 
    
    
int main() {
    volatile int lowtime = 0; 
    volatile int setTime = 0;
//    button.mode(PullUp);
    char bnum = 0;
    char bhit=0;
    float brightness = 0.5f;
    int hour, prevHour;
   
//    button.rise(&flip);
    ledRGB = brightness;
    time_t ctTime; //system time structure
    uLCD.baudrate(2000000); //Crank up Baudrate
    uLCD.cls();    //Clear uLCD screen
    uLCD.color(BLACK);
    uLCD.background_color(WHITE); //SET BACKGROUND COLOR TO WHITE
    //SETS THE BACKGROUND COLOR OF TEXT TO WHITE ON THE ULCD
    uLCD.textbackground_color(WHITE);
    uLCD.locate(0,0);  //Start printing on col0, row0
    uLCD.printf("Getting IP Address\n"); //Print to uLCD
    myled[1] = 1;
    eth.init(); //USE DHCP to get local IP address
    eth.connect(); //Connect to the network
    uLCD.printf("IP ADDRESS is %s\n",eth.getMACAddress()); //Get Ethernet Address and display It on ULCD
    wait(3.0);
    char success[10]={0};  //success first
    char countryFull[20]={0}; //Full Country Name
    char countryAbrv[5]={0}; //Abbreviated Country Name or country Code
    char stateAbrv[5]={0}; //Abbreviated State or region code
    char stateFull[15]={0}; //Full State Name
    char city[15]={0}; //City Name
    char zip[6]={0}; //ZIP CODE
    char latitude[10]={0}; //latitude
    char longitude[10]={0}; //longitude
    char timeZone[30]={0}; //timeZone
    int j=0;
    uLCD.printf("Getting Geolocation Data\n");
    //HANDLES THE HTTP GET REQUEST THE WAY THE FUNCTION IS CALLED HERE IS THE FOLLOWING
    // get(DOMAIN_NAME,BUFFER,TIMEOUT_VAL)
    //DOMAIN_NAME= domain name that get request is sent to
    //BUFFER= buffer to store data returned from the server
    //TIMEOUT_VAL= Time before the request times out
    HTTPResult r = httpClient.get("http://ip-api.com/csv",httpGetData,128); //GET GEOLOCATION DATA (CSV)
    
    if (r==HTTP_OK) { //IF THE DATA WAS RECIEVED
        j=0;
        //parse and display each of the API's location information strings on the LCD
        parse(httpGetData, &j, success); 
        parse(httpGetData,&j,countryFull);
        parse(httpGetData,&j,countryAbrv);
        parse(httpGetData,&j,stateAbrv);
        parse(httpGetData,&j,stateFull);
        parse(httpGetData,&j,city);
        parse(httpGetData,&j,zip);
        parse(httpGetData,&j,latitude);
        parse(httpGetData,&j,longitude);
        parse(httpGetData,&j,timeZone);
        uLCD.cls();
        uLCD.printf("GEOLOCATION DATA RECIEVED\n");  
    } 
    else { //HTTP GET REQUEST ERRORED
        uLCD.cls();
        uLCD.printf("HTTP Error %d", r);
        return -1;
    }
    uLCD.printf("Reading Time...\n");
    char* domainName="us.pool.ntp.org"; //SET TO DOMAIN NAME OF SERVER GETTING TIME FROM
    //GETS THE TIME FROM THE SERVER
    //setTime(DOMAIN_NAME,PORT_NUMBER,TIME_OUT)
    //DOMAIN_NAME= domain name
    //PORT NUMBER=port number (123 for NTP)
    //TIME_OUT= timeout value for request
    ntpClient.setTime(domainName,123,0x00005000);
    uLCD.printf("Time Set\n");
    //Delay for human time to read LCD display
    wait(3.0);
    uLCD.cls();
    //SETS THE BACKGROUND COLOR OF TEXT TO WHITE ON THE ULCD
    uLCD.textbackground_color(WHITE);
    char buffer[80]; //BUFFER TO HOLD FORMATTED TIME DATA
    uLCD.color(BLUE);//SET TEXT COLOR TO BLUE
    uLCD.locate(0,8);
    uLCD.printf("\n\n\n\n\n\n%s, %s %s\n",city,stateAbrv,zip); //PRINT CITY STATE AND ZIP INFORMATION
//    uLCD.printf("\nLAT:%s\nLONG:%s\n",latitude,longitude); //PRINT COUNTRY and LATITUDE AND LONGITUDE 
//    uLCD.printf("Timezone:\n%s",timeZone); //PRINT TIMEZONE
    uLCD.color(RED);
    eth.disconnect(); //DISCONNECT FROM THE NETWORK 
    uLCD.text_height(2); //2x Text Height
    while (1) {
        // loop and periodically update the LCD's time display
        uLCD.locate(0,0);
        ctTime = time(NULL)-(3600*4);  //TIME with offset for eastern time US
        //FORMAT TIME FOR DISPLAY AND STORE FORMATTED RESULT IN BUFFER
        strftime(buffer,80,"%a %b %d\n%T %p %z\n %Z\n",localtime(&ctTime));
        hour = (*(localtime(&ctTime))).tm_hour;
        if(hour!=prevHour && hour == setTime){
            m.speed(-0.8f);
            wait(5);
            m.speed(0.0f);
            prevHour = hour;
        }
        else if(hour!=prevHour && hour == lowtime){
            m.speed(0.8f);
            wait(5);
            m.speed(0.0f);
            prevHour = hour;
        }
        if(hour == prevHour +1){
            prevHour = setTime + 1;
        }
            
        uLCD.printf("Univ Time Clock\n%s", buffer);
//        uLCD.text_height(0.5);
        uLCD.printf("Night Time: %02i\n", setTime);
        uLCD.printf("Morning Time: %02i", lowtime);
        if(blue.readable()){
            if (blue.getc()=='!') {
            if (blue.getc()=='B') { //button data packet
                bnum = blue.getc(); //button number
                bhit = blue.getc(); //1=hit, 0=release
                if (blue.getc()==char(~('!' + 'B' + bnum + bhit))) { //checksum OK?
                    myled = bnum - '0'; //current button number will appear on LEDs
                    switch (bnum) {
                        case '1': //number button 1
                            if (bhit=='1') {
                                setTime = setTime + 1;
                                if (setTime > 24) {
                                  setTime = 0;
                                } 
                            } else {
                                //add release code here
                            }
                            break;
                        case '2': //number button 2
                            if (bhit=='1') {
                                setTime = setTime - 1;
                                if (setTime < 0){
                                    setTime = 24;
                                    }
                            } else {
                                //add release code here
                            }
                            break;
                        case '3': //number button 3
                            if (bhit=='1') {
                               lowtime = lowtime + 1;
                               if (lowtime > 24){
                                   lowtime = 0;
                                   }
                            } else {
                                //add release code here
                            }
                            break;
                        case '4': //number button 4
                            if (bhit=='1') {
                                lowtime = lowtime - 1;
                                if (lowtime < 0){
                                    lowtime = 24;
                                    }
                            } else {
                                //add release code here
                            }
                            break;
                        case '5': //button 5 up arrow
                            if (bhit=='1') {
                                m.speed(0.5f);
                            } else {
                                m.speed(0.0f);
                            }
                            break;
                        case '6': //button 6 down arrow
                            if (bhit=='1') {
                                m.speed(-0.5f);
                            } else {
                                m.speed(0.0f);
                            }
                            break;
                        case '7': //button 7 left arrow
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                brightness = brightness - 0.1f;
                                ledRGB = brightness;
                            }
                            break;
                        case '8': //button 8 right arrow
                            if (bhit=='1') {
                                //add hit code here
                            } else {
                                brightness = brightness + 0.1f;
                                ledRGB = brightness;
                            }
                            break;
                        default:
                            break;
                    }
                }
            }
        }
        }
        wait(.05);
    }  
}
 
 
 
 
 
 
//SET FOR CSV FORMAT: NEEDS TO BE EDITED IF DIFFERENT FORMAT
void parse(char buffer[], int *j, char *string) {
//extracts next location string data item from buffer
    int i=0;
    for (i=0; i<=strlen(buffer); i++) {  //TOTAL SIZE OF RETURNED DATA
        if ((buffer[*j+i] == ',')||(buffer[*j+i] == '\0' )) { //IF comma or end of string
            //comma is the string field delimiter
            string[i]=0; //SETS END OF SRTRING TO 0
            *j=*j+i+1; //UPDATES to 1 after comma seperated value
            break;
        } else string[i]=buffer[*j+i]; //Keep adding to the string
    }
}