#include "mbed.h"
#include "MobileLCD.h"

AnalogIn x1(p18);
AnalogIn y1(p19);
AnalogIn z1(p20);
DigitalOut led(LED1);

DigitalIn start(p21);
Serial pc(USBTX, USBRX); // tx, rx
LocalFileSystem local("local");               // Create the local filesystem under the name "local"

MobileLCD lcd(p5, p6, p7, p8, p9);

int count=0;

int main() {
    lcd.background(0x0000FF);
    lcd.cls();


    lcd.printf("Waiting for start...");
    for (int i=0; i<130; i++) {
        lcd.pixel(i, 80 + sin((float)i / 5.0)*10, 0x000000);
    }
    while (1) {

        pc.printf("%d",start.read());
        if (start) {
            remove("/local/out.csv");
            FILE *fp = fopen("/local/out.csv", "w");  // Open "out.txt" on the local file system for writing
            lcd.background(0x0000FF);
            lcd.cls();
            while (start) {

                pc.printf("XValue %.4f , YValue %.4f , ZValue %.4f\n",x1.read(),y1.read(),z1.read());
                fprintf(fp," %f , %f , %f\n",x1.read(),y1.read(),z1.read());

                lcd.locate(0,3);
                lcd.printf("X:");
                lcd.locate(0,6);
                lcd.printf("Y:");
                lcd.locate(0,8);
                lcd.printf("Z:");
                lcd.pixel(count++, -10 +x1.read()*100, 0x000000);
                lcd.pixel(count, 10+x1.read()*100, 0x000000);
                lcd.pixel(count,30+x1.read()*100, 0x000000);
                if (count == 120 ) {
                    count = 0;
                    lcd.cls();
                }

            }
            fclose(fp);
        }




    }
}