// basic xbee example
// - take chars from the terminal, push them out xbee1
// - listen on xbee2, and print value + 1 to terminal

#include "mbed.h"

Serial xbee1(p9, p10);
DigitalOut rst1(p11);

Serial xbee2(p13, p14);
DigitalOut rst2(p15);

Serial pc(USBTX, USBRX);

int main() {

    // reset the xbees (at least 200ns)
    rst1 = 0;
    rst2 = 0;
    wait_ms(1); 
    rst1 = 1;
    rst2 = 1;
    wait_ms(1); 
 
    while(1) {
        if(pc.readable()) {
            xbee1.putc(pc.getc());
        }
        if(xbee2.readable()) {
            pc.putc(xbee2.getc() + 1);
        }
    }
}