#include "mbed.h"
#include "TextLCD_Rus.h"
#include <string>

TextLCD lcd(D12, D11, D5, D4, D3, D2); // rs, e, d4, d5, d6, d7


//---------------------------------------------------------------------------------------------------------
// Обратите внимание, что русские символы передаются в двухбайтовом представлении (UTF-16)
//---------------------------------------------------------------------------------------------------------
const uint16_t ABC[66]={'А','Б','В','Г','Д','Е','Ё','Ж','З','И','Й','К','Л','М','Н','О','П','Р','С','Т','У','Ф','Х','Ц','Ч','Ш','Щ','Ъ','Ы','Ь','Э','Ю','Я',
                   'а','б','в','г','д','е','ё','ж','з','и','й','к','л','м','н','о','п','р','с','т','у','ф','х','ц','ч','ш','щ','ъ','ы','ь','э','ю','я'};
string str="пример::  AABBCCDDeeffgghh";

int pattern[8][8]={{0xA,0x15,0x0,0x10,0x8,0x4,0x2,0x1},{0x15,0xA,0x0,0x4,0x4,0x4,0x4,0x4},{0xA,0x15,0x0,0x1,0x2,0x4,0x8,0x10},{0x15,0xA,0x0,0x0,0x0,0x1F,0x0,0x0},
                   {0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10},{0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},{0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C},{0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E}};

int main() {

//---------------------------------------------------------------------------------------------------------
// Вывод на экран текста без "руссификации", т.е. как есть
//---------------------------------------------------------------------------------------------------------
      lcd.cls();
      lcd.printf("The module");
      lcd.locate(0,1);
      lcd.printf("TextLCD_Rus");
      wait(3);
//---------------------------------------------------------------------------------------------------------
// Вывод на экран русского текста
//---------------------------------------------------------------------------------------------------------
      lcd.cls();
      lcd.print_rus("Вывод  текста  на  русском  языке!!");
      wait(3);
      lcd.cls();

      lcd.print_rus("Посимвольно::");
      wait(3);
      lcd.cls();
      for (int i=0; i<33; i++) {
          lcd.locate(0,0);
          lcd.putc_rus(ABC[i]);
          lcd.locate(0,1);
          lcd.putc_rus(ABC[i+33]);
          wait(0.5);
        };
//---------------------------------------------------------------------------------------------------------
// Для вывода теста, содержащего как русские, так и остальные символы необходимо любые другие символы удваивать
// Обратите внимание, что параметром функции print_rus является экземпляр объекта string
//---------------------------------------------------------------------------------------------------------
      lcd.cls();
      lcd.print_rus("Вывод  смешенной  строки::");
      wait(3);
      lcd.cls();
      lcd.print_rus("Рассмотрим");
      lcd.locate(0,1);
      lcd.print_rus(str);
      wait(3);
      lcd.cls();
//---------------------------------------------------------------------------------------------------------
// Применение функции сдвига экрана, обратите внимание, что строка "Влево..." вводится за пределами видимой области
//---------------------------------------------------------------------------------------------------------
      lcd.print_rus("Двигаем  текст......");
      lcd.locate(0,1);
      lcd.print_rus("Вправо......");
      wait(0.5);
      for (int i=0; i<16;i++) {
        lcd.ShiftLCD_Right();
        wait(0.5);
      };
      lcd.locate(0,1);
      lcd.print_rus("Влево......  ");
      for (int i=0; i<32;i++) {
        lcd.ShiftLCD_Left();
        wait(0.5);
      };
//---------------------------------------------------------------------------------------------------------
// Управление видимостью курсора
//---------------------------------------------------------------------------------------------------------
      lcd.cls();
      lcd.print_rus("Курсор  невиден");
      wait(5);
      lcd.locate(0,1);
      lcd.print_rus("Он  вверху  слева  ");
      lcd.CursorPosition(0,0);
      wait(5);
      lcd.locate(0,1);
      lcd.print_rus("Символ  мигает      ");
      lcd.CursorPosition(0,0);
      lcd.SetCursor(offCursor|onBlink);
      wait(5);
      lcd.cls();
      lcd.print_rus("Курсор  виден");
      lcd.CursorPosition(0,0);
      lcd.SetCursor(onCursor|offBlink);
      lcd.locate(0,1);
      lcd.print_rus("Он  вверху  слева  ");
      lcd.CursorPosition(0,0);
      wait(5);
      lcd.locate(0,1);
      lcd.print_rus("И  он  не  мигает    ");
      lcd.CursorPosition(0,0);
      lcd.SetCursor(onCursor|offBlink);
      wait(5);
      lcd.locate(0,1);
      lcd.print_rus("А  теперь  мигает  ");
      lcd.CursorPosition(0,0);
      lcd.SetCursor(onCursor|onBlink);
      wait(5);
//---------------------------------------------------------------------------------------------------------
// Включение/выключение дисплея
//---------------------------------------------------------------------------------------------------------
      lcd.cls();
      lcd.print_rus("Выключим  дисплей");
      wait(3);
      lcd.off();
      wait(3);
      lcd.on();
      lcd.locate(0,0);
      lcd.print_rus("Включили  дисплей");
      wait(3);
      lcd.cls();
//---------------------------------------------------------------------------------------------------------
// Пример управления позиционированием курсора
//---------------------------------------------------------------------------------------------------------
      lcd.print_rus("Двигаем  курсор");
      lcd.locate(0,1);
      for (int i=0; i<16; i++) lcd.putc(0x13);
      lcd.CursorPosition(0,1);
      wait(0.5);
      lcd.SetCursor(offCursor|onBlink);
      for (int i=0; i<16; i++) {
          lcd.ShiftCursor_Right();
          wait(0.5);
        };
      lcd.locate(0,1);
      for (int i=0; i<16; i++) lcd.putc(0x14);
      wait(0.5);
      for (int i=0; i<16; i++) {
          lcd.ShiftCursor_Left();
          wait(0.5);
        };
      lcd.locate(0,1);
      lcd.print_rus("Сдвинем  в  1155,,00    ");
      lcd.CursorPosition(15,0);
      wait(3);
      lcd.locate(0,1);
      lcd.print_rus("В  начало  строки  ");
      lcd.home();
      wait(3);
//---------------------------------------------------------------------------------------------------------
// Использование пользовательских символов
//---------------------------------------------------------------------------------------------------------
     lcd.SetCursor(offCursor|offBlink);
     lcd.cls();
     lcd.print_rus("Программируемые  символы");
     for (int i=0; i<8; i++) lcd.writeCGRAM(i, pattern[i]);
     wait(3);
     lcd.cls();
     wait(0.5);
     int loc=0;
     for (int i=0; i<16; i++) {
         for (int k=4; k<9; k++) {
             lcd.locate(0,0);
             for (int j=0; j<16; j++) lcd.putc((k+j) % 4);
             lcd.locate(loc,1);
             if (k<8) {lcd.putc(k);} else lcd.putc(0xFF);
             wait(0.2);
            };
         loc++;
        };
     wait(2);     
}