#include "sfh_mbed.h"
#include "SlidingWindow.h"
#include "LookupTable.h"

#define LOOKUP_TABLE_SIZE 3000
#define SLIDING_WINDOW_SIZE 300

//static uint32_t sliding_window_index = 0; 


uint32_t hash (const char *data, uint16_t len) {
    // This is mostly Paul Hsieh's original code
    uint32_t hash, tmp;
    int rem;

    if (len <= 0 || data == 0) {
        return 0;
    }

    hash = len;
    rem = len & 3;
    len >>= 2;

    /* Main loop */
    while (len > 0) {
        hash += *((uint16_t *) data);

        /* To make a long story short, the C standard states that the
         * shift operator's operands must be promoted to (unsigned) int,
         * which is (usually) 32 bits wide on PC and 16 on Arduino. This
         * results in different behaviour, since part of the result gets
         * truncated on Arduino, so we cast the result to make sure all
         * bits are kept.
         */
        tmp = ((uint32_t) (*((uint16_t *) (data + 2))) << 11) ^ hash;

        hash = (hash << 16) ^ tmp;
        data += 2 * sizeof (uint16_t);
        hash += hash >> 11;
        len--;
    }

    /* Handle end cases */
    switch (rem) {
        case 3:
            hash += * ((uint16_t *) data);
            hash ^= hash << 16;
            hash ^= ((signed char) data[2]) << 18;
            hash += hash >> 11;
            break;

        case 2:
            hash += * ((uint16_t *) data);
            hash ^= hash << 11;
            hash += hash >> 17;
            break;

        case 1:
            hash += (signed char) * data;
            hash ^= hash << 10;
            hash += hash >> 1;
    }

    /* Force "avalanching" of final 127 bits */
    hash ^= hash << 3;
    hash += hash >> 5;
    hash ^= hash << 4;
    hash += hash >> 17;
    hash ^= hash << 25;
    hash += hash >> 6;

    return hash;
}